/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addr_disable;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.cxf.systest.ws.AbstractWSATestBase;
import org.apache.cxf.systest.ws.addr_disable.Server;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersPortType;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersService;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSADisableTest
extends AbstractWSATestBase {
    private final QName serviceName = new QName("http://apache.org/cxf/systest/ws/addr_feature/", "AddNumbersService");

    @Before
    public void setUp() throws Exception {
        this.createBus();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSADisableTest.assertTrue((String)"server did not launch correctly", (boolean)WSADisableTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testDisableServerSide() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getService().getAddNumbersPort();
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:9095/jaxws/add");
        WSADisableTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String base = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/";
        String expectedOut = base + "addNumbersRequest</Action>";
        String expectedIn = "http://www.w3.org/2005/08/addressing";
        WSADisableTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSADisableTest.assertTrue((input.toString().indexOf(expectedIn) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDisableAll() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getService().getAddNumbersPort(new WebServiceFeature[]{new AddressingFeature(false)});
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:9095/jaxws/add");
        WSADisableTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "http://www.w3.org/2005/08/addressing";
        String expectedIn = "http://www.w3.org/2005/08/addressing";
        WSADisableTest.assertTrue((output.toString().indexOf(expectedOut) == -1 ? 1 : 0) != 0);
        WSADisableTest.assertTrue((input.toString().indexOf(expectedIn) == -1 ? 1 : 0) != 0);
    }

    private AddNumbersService getService() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/add_numbers.wsdl");
        WSADisableTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        WSADisableTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service;
    }
}

