/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addr_feature;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.systest.ws.AbstractWSATestBase;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersPortType;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersService;
import org.apache.cxf.systest.ws.addr_feature.Server;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSAClientServerTest
extends AbstractWSATestBase {
    private final QName serviceName = new QName("http://apache.org/cxf/systest/ws/addr_feature/", "AddNumbersService");

    @Before
    public void setUp() throws Exception {
        this.createBus();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSAClientServerTest.assertTrue((String)"server did not launch correctly", (boolean)WSAClientServerTest.launchServer(Server.class));
    }

    @Test
    public void testNoWsaFeature() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(AddNumbersPortType.class);
        factory.setAddress("http://localhost:9091/jaxws/add");
        AddNumbersPortType port = (AddNumbersPortType)factory.create();
        WSAClientServerTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "<Address>http://www.w3.org/2005/08/addressing/anonymous</Address>";
        String expectedIn = "<RelatesTo xmlns=\"http://www.w3.org/2005/08/addressing\">";
        WSAClientServerTest.assertTrue((output.toString().indexOf(expectedOut) == -1 ? 1 : 0) != 0);
        WSAClientServerTest.assertTrue((input.toString().indexOf(expectedIn) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testCxfWsaFeature() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(AddNumbersPortType.class);
        factory.setAddress("http://localhost:9091/jaxws/add");
        factory.getFeatures().add(new WSAddressingFeature());
        AddNumbersPortType port = (AddNumbersPortType)factory.create();
        WSAClientServerTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "<Address>http://www.w3.org/2005/08/addressing/anonymous</Address>";
        String expectedIn = "<RelatesTo xmlns=\"http://www.w3.org/2005/08/addressing\">";
        WSAClientServerTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAClientServerTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testJaxwsWsaFeature() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getPort();
        WSAClientServerTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "<Address>http://www.w3.org/2005/08/addressing/anonymous</Address>";
        String expectedIn = "<RelatesTo xmlns=\"http://www.w3.org/2005/08/addressing\">";
        WSAClientServerTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAClientServerTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    private AddNumbersPortType getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/add_numbers.wsdl");
        WSAClientServerTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        WSAClientServerTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getAddNumbersPort(new WebServiceFeature[]{new AddressingFeature()});
    }
}

