/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addr_fromjava;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.systest.ws.AbstractWSATestBase;
import org.apache.cxf.systest.ws.addr_fromjava.client.AddNumberImpl;
import org.apache.cxf.systest.ws.addr_fromjava.client.AddNumberImplService;
import org.apache.cxf.systest.ws.addr_fromjava.client.AddNumbersException_Exception;
import org.apache.cxf.systest.ws.addr_fromjava.server.Server;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSAFromJavaTest
extends AbstractWSATestBase {
    @Before
    public void setUp() throws Exception {
        this.createBus();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSAFromJavaTest.assertTrue((String)"server did not launch correctly", (boolean)WSAFromJavaTest.launchServer(Server.class));
    }

    @Test
    public void testAddNumbers() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumberImpl port = this.getPort();
        WSAFromJavaTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "http://cxf.apache.org/input";
        WSAFromJavaTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        String expectedIn = "http://cxf.apache.org/output";
        WSAFromJavaTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbersFault() {
        ByteArrayOutputStream output;
        ByteArrayOutputStream input;
        block3: {
            input = this.setupInLogging();
            output = this.setupOutLogging();
            AddNumberImpl port = this.getPort();
            try {
                port.addNumbers(-1, 2);
            }
            catch (AddNumbersException_Exception e) {
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        WSAFromJavaTest.assertTrue((output.toString().indexOf("http://cxf.apache.org/input") != -1 ? 1 : 0) != 0);
        String expectedFault = "http://server.addr_fromjava.ws.systest.cxf.apache.org/AddNumberImpl/Fault/AddNumbersException";
        WSAFromJavaTest.assertTrue((input.toString().indexOf(expectedFault) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbers2() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumberImpl port = this.getPort();
        WSAFromJavaTest.assertEquals((Object)3, (Object)port.addNumbers2(1, 2));
        String base = "http://server.addr_fromjava.ws.systest.cxf.apache.org/AddNumberImpl";
        String expectedOut = base + "/addNumbers2";
        WSAFromJavaTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        String expectedIn = base + "/addNumbers2Response";
        WSAFromJavaTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbers3Fault() {
        ByteArrayOutputStream output;
        ByteArrayOutputStream input;
        block3: {
            input = this.setupInLogging();
            output = this.setupOutLogging();
            AddNumberImpl port = this.getPort();
            try {
                port.addNumbers3(-1, 2);
            }
            catch (AddNumbersException_Exception e) {
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        WSAFromJavaTest.assertTrue((output.toString().indexOf("http://cxf.apache.org/input") != -1 ? 1 : 0) != 0);
        WSAFromJavaTest.assertTrue((input.toString().indexOf("http://cxf.apache.org/fault3") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbersJaxWsContext() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumberImpl port = this.getPort();
        BindingProvider bp = (BindingProvider)port;
        Map requestContext = bp.getRequestContext();
        requestContext.put("javax.xml.ws.soap.http.soapaction.uri", "cxf");
        WSAFromJavaTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "cxf</Action>";
        WSAFromJavaTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAFromJavaTest.assertTrue((output.toString().indexOf("SOAPAction=[\"cxf\"]") != -1 ? 1 : 0) != 0);
        String expectedIn = "http://cxf.apache.org/output";
        WSAFromJavaTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    private AddNumberImpl getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/add_numbers-fromjava.wsdl");
        WSAFromJavaTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        AddNumberImplService service = new AddNumberImplService(wsdl);
        WSAFromJavaTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getAddNumberImplPort();
    }
}

