/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addr_fromwsdl;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.cxf.systest.ws.AbstractWSATestBase;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersFault_Exception;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersPortType;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersService;
import org.apache.cxf.systest.ws.addr_fromwsdl.Server;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSAFromWSDLTest
extends AbstractWSATestBase {
    private static final String BASE_URI = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/";
    private final QName serviceName = new QName("http://apache.org/cxf/systest/ws/addr_feature/", "AddNumbersService");

    @Before
    public void setUp() throws Exception {
        this.createBus();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSAFromWSDLTest.assertTrue((String)"server did not launch correctly", (boolean)WSAFromWSDLTest.launchServer(Server.class));
    }

    @Test
    public void testAddNumbers() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getPort();
        WSAFromWSDLTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String expectedOut = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/addNumbersRequest";
        String expectedIn = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/addNumbersResponse";
        WSAFromWSDLTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAFromWSDLTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbers2() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getPort();
        WSAFromWSDLTest.assertEquals((Object)3, (Object)port.addNumbers2(1, 2));
        String expectedOut = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/add2In";
        String expectedIn = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/add2Out";
        WSAFromWSDLTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAFromWSDLTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbers3() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getPort();
        WSAFromWSDLTest.assertEquals((Object)3, (Object)port.addNumbers3(1, 2));
        String expectedOut = "3in";
        String expectedIn = "3out";
        WSAFromWSDLTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAFromWSDLTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbersFault() throws Exception {
        ByteArrayOutputStream output;
        ByteArrayOutputStream input;
        block3: {
            input = this.setupInLogging();
            output = this.setupOutLogging();
            AddNumbersPortType port = this.getPort();
            try {
                port.addNumbers(-1, 2);
            }
            catch (AddNumbersFault_Exception ex) {
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        String expectedOut = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/addNumbersRequest";
        String expectedIn = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/Fault/addNumbersFault";
        WSAFromWSDLTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAFromWSDLTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testAddNumbersFault3() throws Exception {
        ByteArrayOutputStream output;
        ByteArrayOutputStream input;
        block3: {
            input = this.setupInLogging();
            output = this.setupOutLogging();
            AddNumbersPortType port = this.getPort();
            try {
                port.addNumbers3(-1, 2);
            }
            catch (AddNumbersFault_Exception ex) {
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        String expectedOut = "3in";
        String expectedIn = "3fault";
        WSAFromWSDLTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAFromWSDLTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    private AddNumbersPortType getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/add_numbers.wsdl");
        WSAFromWSDLTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        WSAFromWSDLTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getAddNumbersPort(new WebServiceFeature[]{new AddressingFeature()});
    }
}

