/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addr_wsdl;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.systest.ws.AbstractWSATestBase;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersPortType;
import org.apache.cxf.systest.ws.addr_feature.AddNumbersService;
import org.apache.cxf.systest.ws.addr_wsdl.Server;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSAPureWsdlTest
extends AbstractWSATestBase {
    private final QName serviceName = new QName("http://apache.org/cxf/systest/ws/addr_feature/", "AddNumbersService");

    @Before
    public void setUp() throws Exception {
        this.createBus();
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSAPureWsdlTest.assertTrue((String)"server did not launch correctly", (boolean)WSAPureWsdlTest.launchServer(Server.class));
    }

    @Test
    public void testBasicInvocation() throws Exception {
        ByteArrayOutputStream input = this.setupInLogging();
        ByteArrayOutputStream output = this.setupOutLogging();
        AddNumbersPortType port = this.getPort();
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:9094/jaxws/add");
        WSAPureWsdlTest.assertEquals((Object)3, (Object)port.addNumbers(1, 2));
        String base = "http://apache.org/cxf/systest/ws/addr_feature/AddNumbersPortType/";
        String expectedOut = base + "addNumbersRequest</Action>";
        String expectedIn = base + "addNumbersResponse</Action>";
        WSAPureWsdlTest.assertTrue((output.toString().indexOf(expectedOut) != -1 ? 1 : 0) != 0);
        WSAPureWsdlTest.assertTrue((input.toString().indexOf(expectedIn) != -1 ? 1 : 0) != 0);
    }

    private AddNumbersPortType getPort() {
        URL wsdl = ((Object)((Object)this)).getClass().getResource("/wsdl/add_numbers.wsdl");
        WSAPureWsdlTest.assertNotNull((String)"WSDL is null", (Object)wsdl);
        AddNumbersService service = new AddNumbersService(wsdl, this.serviceName);
        WSAPureWsdlTest.assertNotNull((String)"Service is null ", (Object)((Object)service));
        return service.getAddNumbersPort();
    }
}

