/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.systest.ws.addressing.MAPTest;
import org.apache.cxf.systest.ws.addressing.MAPTestBase;
import org.apache.cxf.systest.ws.addressing.VerificationCache;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.soap.VersionTransformer;
import org.apache.cxf.ws.addressing.v200408.AttributedURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderVerifier
extends AbstractSoapInterceptor {
    VerificationCache verificationCache;
    String currentNamespaceURI;

    public HeaderVerifier() {
        super("post-protocol");
    }

    public Set<QName> getUnderstoodHeaders() {
        return Names.HEADERS;
    }

    public void handleMessage(SoapMessage message) {
        this.mediate(message);
    }

    public void handleFault(SoapMessage message) {
        this.mediate(message);
    }

    private void mediate(SoapMessage message) {
        boolean outgoingPartialResponse = this.isOutgoingPartialResponse(message);
        if (outgoingPartialResponse) {
            this.addPartialResponseHeader(message);
        }
        this.verify(message, outgoingPartialResponse);
    }

    private void addPartialResponseHeader(SoapMessage message) {
        try {
            List header = message.getHeaders();
            Document doc = DOMUtils.createDocument();
            SoapVersion ver = message.getVersion();
            Element hdr = doc.createElementNS(ver.getHeader().getNamespaceURI(), ver.getHeader().getLocalPart());
            hdr.setPrefix(ver.getHeader().getPrefix());
            this.marshallFrom("urn:piggyback_responder", hdr, this.getMarshaller());
            Element elem = DOMUtils.getFirstElement((Node)hdr);
            while (elem != null) {
                Header holder = new Header(new QName(elem.getNamespaceURI(), elem.getLocalName()), (Object)elem, null);
                header.add(holder);
                elem = DOMUtils.getNextElement((Element)elem);
            }
        }
        catch (Exception e) {
            this.verificationCache.put("SOAP header addition failed: " + e);
            e.printStackTrace();
        }
    }

    private void verify(SoapMessage message, boolean outgoingPartialResponse) {
        try {
            ArrayList<String> wsaHeaders = new ArrayList<String>();
            List headers = message.getHeaders();
            if (headers != null) {
                this.recordWSAHeaders(headers, wsaHeaders, "http://www.w3.org/2005/08/addressing");
                this.recordWSAHeaders(headers, wsaHeaders, "http://schemas.xmlsoap.org/ws/2004/08/addressing");
                this.recordWSAHeaders(headers, wsaHeaders, MAPTestBase.CUSTOMER_NAME.getNamespaceURI());
            }
            boolean partialResponse = this.isIncomingPartialResponse(message) || outgoingPartialResponse;
            this.verificationCache.put(MAPTest.verifyHeaders(wsaHeaders, partialResponse, this.isRequestLeg(message)));
        }
        catch (SOAPException se) {
            this.verificationCache.put("SOAP header verification failed: " + (Object)((Object)se));
        }
    }

    private void recordWSAHeaders(List<Header> headers, List<String> wsaHeaders, String namespaceURI) {
        Iterator<Header> iter = headers.iterator();
        while (iter.hasNext()) {
            String headerText;
            Element hdr;
            Object obj = iter.next().getObject();
            if (!(obj instanceof Element) || !namespaceURI.equals((hdr = (Element)obj).getNamespaceURI())) continue;
            if (namespaceURI.endsWith("addressing")) {
                this.currentNamespaceURI = namespaceURI;
                wsaHeaders.add(hdr.getLocalName());
                continue;
            }
            if (!MAPTestBase.CUSTOMER_NAME.getNamespaceURI().equals(namespaceURI) || !"Key#123456789".equals(headerText = hdr.getTextContent())) continue;
            wsaHeaders.add(hdr.getLocalName());
        }
    }

    private boolean isRequestLeg(SoapMessage message) {
        return ContextUtils.isRequestor((Message)message) && ContextUtils.isOutbound((Message)message) || !ContextUtils.isRequestor((Message)message) && !ContextUtils.isOutbound((Message)message);
    }

    private boolean isOutgoingPartialResponse(SoapMessage message) {
        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.outbound");
        return ContextUtils.isOutbound((Message)message) && !ContextUtils.isRequestor((Message)message) && maps != null && "http://www.w3.org/2005/08/addressing/anonymous".equals(maps.getTo().getValue());
    }

    private boolean isIncomingPartialResponse(SoapMessage message) throws SOAPException {
        AddressingProperties maps = (AddressingProperties)message.get((Object)"javax.xml.ws.addressing.context.inbound");
        return !ContextUtils.isOutbound((Message)message) && ContextUtils.isRequestor((Message)message) && maps != null && "http://www.w3.org/2005/08/addressing/anonymous".equals(maps.getTo().getValue());
    }

    private Marshaller getMarshaller() throws JAXBException {
        JAXBContext jaxbContext = VersionTransformer.getExposedJAXBContext((String)this.currentNamespaceURI);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    private void marshallFrom(String from, Element header, Marshaller marshaller) throws JAXBException {
        if ("http://www.w3.org/2005/08/addressing".equals(this.currentNamespaceURI)) {
            String u = "urn:piggyback_responder";
            AttributedURIType value = ContextUtils.getAttributedURI((String)u);
            marshaller.marshal((Object)new JAXBElement(Names.WSA_FROM_QNAME, AttributedURIType.class, (Object)value), (Node)header);
        } else if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(this.currentNamespaceURI)) {
            AttributedURI value = VersionTransformer.Names200408.WSA_OBJECT_FACTORY.createAttributedURI();
            value.setValue(from);
            QName qname = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "From");
            marshaller.marshal((Object)new JAXBElement(qname, AttributedURI.class, (Object)value), (Node)header);
        }
    }

    public void setVerificationCache(VerificationCache cache) {
        this.verificationCache = cache;
    }
}

