/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.addressing.spring;

import java.util.List;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.test.AbstractCXFTest;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.soap.MAPCodec;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAFeatureTest
extends AbstractCXFTest {
    @Test
    public void testServerFactory() {
        JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
        sf.getFeatures().add(new WSAddressingFeature());
        sf.setServiceBean((Object)new GreeterImpl());
        sf.setAddress("http://localhost:9000/test");
        sf.setStart(false);
        sf.setBus(this.getBus());
        Server server = sf.create();
        Endpoint endpoint = server.getEndpoint();
        this.checkAddressInterceptors(endpoint.getInInterceptors());
    }

    @Test
    public void testClientProxyFactory() {
        JaxWsProxyFactoryBean cf = new JaxWsProxyFactoryBean();
        cf.setAddress("http://localhost:9000/test");
        cf.getFeatures().add(new WSAddressingFeature());
        cf.setServiceClass(Greeter.class);
        Greeter greeter = (Greeter)cf.create();
        Client client = ClientProxy.getClient((Object)greeter);
        this.checkAddressInterceptors(client.getInInterceptors());
    }

    private void checkAddressInterceptors(List<Interceptor> interceptors) {
        boolean hasAg = false;
        boolean hasCodec = false;
        for (Interceptor i : interceptors) {
            if (i instanceof MAPAggregator) {
                hasAg = true;
                continue;
            }
            if (!(i instanceof MAPCodec)) continue;
            hasCodec = true;
        }
        WSAFeatureTest.assertTrue((boolean)hasAg);
        WSAFeatureTest.assertTrue((boolean)hasCodec);
    }
}

