/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.systest.ws.policy.GreeterImpl;
import org.apache.cxf.systest.ws.policy.PolicyTestUtils;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.ws.policy.ServerPolicyInInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutInterceptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddressingInlinePolicyTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(AddressingInlinePolicyTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        AddressingInlinePolicyTest.assertTrue((String)"server did not launch correctly", (boolean)AddressingInlinePolicyTest.launchServer(Server.class, (boolean)false));
    }

    @Test
    public void testUsingAddressing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr-inline-policy-old.xml");
        PolicyTestUtils.setPolicyConstants(this.bus, "http://www.w3.org/2006/07/ws-policy");
        BusFactory.setDefaultBus((Bus)this.bus);
        BasicGreeterService gs = new BasicGreeterService();
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        AddressingInlinePolicyTest.testInterceptors(this.bus);
        greeter.greetMeOneWay("CXF");
        AddressingInlinePolicyTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
        }
        catch (PingMeFault ex) {
            AddressingInlinePolicyTest.fail((String)"First invocation should have succeeded.");
        }
        try {
            greeter.pingMe();
            AddressingInlinePolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            AddressingInlinePolicyTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            AddressingInlinePolicyTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
    }

    private static void testInterceptors(Bus b) {
        boolean hasServerIn = false;
        boolean hasServerOut = false;
        List inInterceptors = b.getInInterceptors();
        for (Interceptor i : inInterceptors) {
            if (!(i instanceof ServerPolicyInInterceptor)) continue;
            hasServerIn = true;
        }
        AddressingInlinePolicyTest.assertTrue((boolean)hasServerIn);
        for (Interceptor i : b.getOutInterceptors()) {
            if (!(i instanceof ServerPolicyOutInterceptor)) continue;
            hasServerOut = true;
        }
        AddressingInlinePolicyTest.assertTrue((boolean)hasServerOut);
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr-inline-policy.xml");
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
            LOG.info("Published greeter endpoint.");
            AddressingInlinePolicyTest.testInterceptors(bus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

