/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.ws.policy.GreeterImpl;
import org.apache.cxf.systest.ws.policy.PolicyTestUtils;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.systest.ws.util.InMessageRecorder;
import org.apache.cxf.systest.ws.util.MessageFlow;
import org.apache.cxf.systest.ws.util.OutMessageRecorder;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.selector.MinimalAlternativeSelector;
import org.apache.cxf.ws.rm.RMUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddressingOptionalPolicyTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(AddressingOptionalPolicyTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        AddressingOptionalPolicyTest.assertTrue((String)"server did not launch correctly", (boolean)AddressingOptionalPolicyTest.launchServer(Server.class));
    }

    @Test
    public void testUsingAddressing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr-optional.xml");
        Bus bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr-optional.xml");
        PolicyTestUtils.setPolicyConstants(bus, "http://www.w3.org/2006/07/ws-policy");
        BusFactory.setDefaultBus((Bus)bus);
        InMessageRecorder in = new InMessageRecorder();
        bus.getInInterceptors().add(in);
        OutMessageRecorder out = new OutMessageRecorder();
        bus.getOutInterceptors().add(out);
        BasicGreeterService gs = new BasicGreeterService();
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        greeter.greetMeOneWay("CXF");
        AddressingOptionalPolicyTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
        }
        catch (PingMeFault ex) {
            AddressingOptionalPolicyTest.fail((String)"First invocation should have succeeded.");
        }
        try {
            greeter.pingMe();
            AddressingOptionalPolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            AddressingOptionalPolicyTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            AddressingOptionalPolicyTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
        MessageFlow mf = new MessageFlow(out.getOutboundMessages(), in.getInboundMessages());
        for (int i = 0; i < 3; ++i) {
            mf.verifyHeader(RMUtils.getAddressingConstants().getMessageIDQName(), true, i);
            mf.verifyHeader(RMUtils.getAddressingConstants().getMessageIDQName(), false, i);
        }
    }

    @Test
    public void testNotUsingAddressing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr-optional.xml");
        BusFactory.setDefaultBus((Bus)this.bus);
        InMessageRecorder in = new InMessageRecorder();
        this.bus.getInInterceptors().add(in);
        OutMessageRecorder out = new OutMessageRecorder();
        this.bus.getOutInterceptors().add(out);
        ((PolicyEngine)this.bus.getExtension(PolicyEngine.class)).setAlternativeSelector((AlternativeSelector)new MinimalAlternativeSelector());
        BasicGreeterService gs = new BasicGreeterService();
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        greeter.greetMeOneWay("CXF");
        AddressingOptionalPolicyTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
        }
        catch (PingMeFault ex) {
            AddressingOptionalPolicyTest.fail((String)"First invocation should have succeeded.");
        }
        try {
            greeter.pingMe();
            AddressingOptionalPolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            AddressingOptionalPolicyTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            AddressingOptionalPolicyTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
        MessageFlow mf = new MessageFlow(out.getOutboundMessages(), in.getInboundMessages());
        for (int i = 0; i < 3; ++i) {
            mf.verifyNoHeader(RMUtils.getAddressingConstants().getMessageIDQName(), true, i);
            mf.verifyNoHeader(RMUtils.getAddressingConstants().getMessageIDQName(), false, i);
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr-optional.xml");
            PolicyTestUtils.setPolicyConstants(bus, "http://www.w3.org/2006/07/ws-policy");
            BusFactory.setDefaultBus((Bus)bus);
            LoggingInInterceptor in = new LoggingInInterceptor();
            bus.getInInterceptors().add(in);
            bus.getInFaultInterceptors().add(in);
            LoggingOutInterceptor out = new LoggingOutInterceptor();
            bus.getOutInterceptors().add(out);
            bus.getOutFaultInterceptors().add(out);
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
            LOG.info("Published greeter endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

