/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.ws.policy.GreeterImpl;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddressingPolicyTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(AddressingPolicyTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        AddressingPolicyTest.assertTrue((String)"server did not launch correctly", (boolean)AddressingPolicyTest.launchServer(Server.class));
    }

    @Test
    public void testUsingAddressing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr.xml");
        BusFactory.setDefaultBus((Bus)this.bus);
        LoggingInInterceptor in = new LoggingInInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        this.bus.getOutInterceptors().add(out);
        this.bus.getOutFaultInterceptors().add(out);
        BasicGreeterService gs = new BasicGreeterService();
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        greeter.greetMeOneWay("CXF");
        AddressingPolicyTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
        }
        catch (PingMeFault ex) {
            AddressingPolicyTest.fail((String)"First invocation should have succeeded.");
        }
        try {
            greeter.pingMe();
            AddressingPolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            AddressingPolicyTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            AddressingPolicyTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/ws/policy/addr.xml");
            BusFactory.setDefaultBus((Bus)bus);
            LoggingInInterceptor in = new LoggingInInterceptor();
            bus.getInInterceptors().add(in);
            bus.getInFaultInterceptors().add(in);
            LoggingOutInterceptor out = new LoggingOutInterceptor();
            bus.getOutInterceptors().add(out);
            bus.getOutFaultInterceptors().add(out);
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
            LOG.info("Published greeter endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

