/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.ws.policy.HttpGreeterImpl;
import org.apache.cxf.systest.ws.policy.PolicyTestUtils;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.policy.PolicyException;
import org.junit.BeforeClass;
import org.junit.Test;

public class HTTPClientPolicyTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(HTTPClientPolicyTest.class);
    private static final String POLICY_ENGINE_ENABLED_CFG = "org/apache/cxf/systest/ws/policy/http.xml";
    private static final String POLICY_VIA_FEATURE_CFG = "org/apache/cxf/systest/ws/policy/http_client_policy_feature.xml";
    private static final QName GREETER_QNAME = new QName("http://cxf.apache.org/greeter_control", "BasicGreeterService");

    @BeforeClass
    public static void startServers() throws Exception {
        HTTPClientPolicyTest.assertTrue((String)"server did not launch correctly", (boolean)HTTPClientPolicyTest.launchServer(Server.class));
    }

    @Test
    public void testUsingHTTPClientPolicies() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus(POLICY_ENGINE_ENABLED_CFG);
        BusFactory.setDefaultBus((Bus)this.bus);
        PolicyTestUtils.setPolicyConstants(this.bus, "http://www.w3.org/2006/07/ws-policy");
        LoggingInInterceptor in = new LoggingInInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        this.bus.getOutInterceptors().add(out);
        this.bus.getOutFaultInterceptors().add(out);
        URL url = HTTPClientPolicyTest.class.getResource("http_client_greeter.wsdl");
        BasicGreeterService gs = new BasicGreeterService(url, GREETER_QNAME);
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        try {
            greeter.sayHi();
            HTTPClientPolicyTest.fail((String)"Did not receive expected PolicyException.");
        }
        catch (WebServiceException wex) {
            PolicyException ex = (PolicyException)wex.getCause();
            HTTPClientPolicyTest.assertEquals((Object)"INCOMPATIBLE_HTTPCLIENTPOLICY_ASSERTIONS", (Object)ex.getCode());
        }
        greeter.greetMeOneWay("CXF");
        HTTPClientPolicyTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.greetMe("cxf");
        }
        catch (Exception ex) {
            HTTPClientPolicyTest.assertTrue((boolean)(ex.getCause() instanceof SocketTimeoutException));
        }
        try {
            greeter.pingMe();
            HTTPClientPolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            HTTPClientPolicyTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            HTTPClientPolicyTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
    }

    @Test
    public void testHTTPClientPolicyViaFeature() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus(POLICY_VIA_FEATURE_CFG);
        BusFactory.setDefaultBus((Bus)this.bus);
        URL url = HTTPClientPolicyTest.class.getResource("bare_greeter.wsdl");
        BasicGreeterService gs = new BasicGreeterService(url, GREETER_QNAME);
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        greeter.greetMeOneWay("CXF");
        HTTPConduit c = (HTTPConduit)ClientProxy.getClient((Object)greeter).getConduit();
        HTTPClientPolicyTest.assertNotNull((String)"expected HTTPConduit", (Object)c);
        HTTPClientPolicyTest.assertNotNull((String)"expected DecoupledEndpoint", (Object)c.getClient().getDecoupledEndpoint());
        HTTPClientPolicyTest.assertEquals((String)"unexpected DecoupledEndpoint", (Object)"http://localhost:9990/decoupled_endpoint", (Object)c.getClient().getDecoupledEndpoint());
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus();
            BusFactory.setDefaultBus((Bus)bus);
            LoggingInInterceptor in = new LoggingInInterceptor();
            LoggingOutInterceptor out = new LoggingOutInterceptor();
            bus.getInInterceptors().add(in);
            bus.getOutInterceptors().add(out);
            bus.getOutFaultInterceptors().add(out);
            HttpGreeterImpl implementor = new HttpGreeterImpl();
            implementor.setThrowAlways(true);
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            Endpoint.publish((String)address, (Object)((Object)implementor));
            LOG.info("Published greeter endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

