/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.BasicGreeterService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.PingMeFault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.ws.policy.GreeterImpl;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class HTTPServerPolicyTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(HTTPServerPolicyTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        HTTPServerPolicyTest.assertTrue((String)"server did not launch correctly", (boolean)HTTPServerPolicyTest.launchServer(Server.class));
    }

    @Test
    public void testUsingHTTPServerPolicies() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        BasicGreeterService gs = new BasicGreeterService();
        Greeter greeter = gs.getGreeterPort();
        LoggingInInterceptor in = new LoggingInInterceptor();
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        bus.getInInterceptors().add(in);
        bus.getOutInterceptors().add(out);
        LOG.fine("Created greeter client.");
        try {
            greeter.sayHi();
            HTTPServerPolicyTest.fail((String)"Did not receive expected Exception.");
        }
        catch (WebServiceException wse) {
            SoapFault sf = (SoapFault)wse.getCause();
            HTTPServerPolicyTest.assertEquals((Object)"Server", (Object)sf.getFaultCode().getLocalPart());
            String text = sf.getMessage();
            HTTPServerPolicyTest.assertTrue((boolean)text.contains("{http://cxf.apache.org/transports/http/configuration}server"));
        }
        HTTPServerPolicyTest.assertEquals((Object)"CXF", (Object)greeter.greetMe("cxf"));
        try {
            greeter.pingMe();
            HTTPServerPolicyTest.fail((String)"Expected PingMeFault not thrown.");
        }
        catch (PingMeFault ex) {
            HTTPServerPolicyTest.assertEquals((Object)2, (Object)ex.getFaultInfo().getMajor());
            HTTPServerPolicyTest.assertEquals((Object)1, (Object)ex.getFaultInfo().getMinor());
        }
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("org/apache/cxf/systest/ws/policy/http-server.xml");
            GreeterImpl implementor = new GreeterImpl();
            implementor.setThrowAlways(true);
            Endpoint.publish((String)"http://localhost:9020/SoapContext/GreeterPort", (Object)((Object)implementor));
            LOG.info("Published greeter endpoint.");
            LoggingInInterceptor in = new LoggingInInterceptor();
            LoggingOutInterceptor out = new LoggingOutInterceptor();
            bus.getInInterceptors().add(in);
            bus.getOutInterceptors().add(out);
            bus.getOutFaultInterceptors().add(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

