/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.rm;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.systest.ws.policy.GreeterImpl;
import org.apache.cxf.systest.ws.rm.MessageLossSimulator;
import org.apache.cxf.systest.ws.util.InMessageRecorder;
import org.apache.cxf.systest.ws.util.MessageFlow;
import org.apache.cxf.systest.ws.util.MessageRecorder;
import org.apache.cxf.systest.ws.util.OutMessageRecorder;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.persistence.jdbc.RMTxStore;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClientPersistenceTest
extends AbstractBusClientServerTestBase {
    public static final String GREETMEONEWAY_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeOneWayRequest";
    public static final String GREETME_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeRequest";
    private static final Logger LOG = LogUtils.getLogger(ClientPersistenceTest.class);
    private Greeter greeter;
    private OutMessageRecorder out;
    private InMessageRecorder in;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void startServers() throws Exception {
        RMTxStore.deleteDatabaseFiles((String)"rmdb", (boolean)false);
        String derbyHome = System.getProperty("derby.system.home");
        try {
            if (derbyHome == null) {
                System.setProperty("derby.system.home", "derby-server");
            } else {
                System.setProperty("derby.system.home", derbyHome + "-server");
            }
            ClientPersistenceTest.assertTrue((String)"server did not launch correctly", (boolean)ClientPersistenceTest.launchServer(Server.class));
        }
        finally {
            if (derbyHome == null) {
                System.clearProperty("derby.system.home");
            } else {
                System.setProperty("derby.system.home", derbyHome);
            }
        }
        RMTxStore.deleteDatabaseFiles();
    }

    @AfterClass
    public static void tearDownOnce() {
        RMTxStore.deleteDatabaseFiles((String)"rmdb", (boolean)false);
    }

    @Test
    public void testRecovery() throws Exception {
        this.startClient();
        this.populateStore();
        this.verifyStorePopulation();
        this.stopClient();
        this.startClient();
        this.recover();
        this.verifyRecovery();
    }

    void startClient() {
        LOG.fine("Creating greeter client");
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("/org/apache/cxf/systest/ws/rm/persistent.xml");
        BusFactory.setDefaultBus((Bus)this.bus);
        GreeterService gs = new GreeterService();
        this.greeter = gs.getGreeterPort();
        ((BindingProvider)this.greeter).getRequestContext().put("schema-validation-enabled", Boolean.TRUE);
        this.out = new OutMessageRecorder();
        this.in = new InMessageRecorder();
        this.bus.getOutInterceptors().add(this.out);
        this.bus.getInInterceptors().add(this.in);
    }

    void populateStore() throws Exception {
        ((RMManager)this.bus.getExtension(RMManager.class)).getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("60000"));
        this.bus.getOutInterceptors().add(new MessageLossSimulator());
        this.greeter.greetMeOneWay("one");
        this.greeter.greetMeOneWay("two");
        this.greeter.greetMeOneWay("three");
        this.greeter.greetMeOneWay("four");
        MessageFlow mf = new MessageFlow(this.out.getOutboundMessages(), this.in.getInboundMessages());
        ClientPersistenceTest.assertNotNull((Object)((Object)mf));
        this.awaitMessages(5, 3);
        mf.verifyMessages(5, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3", "4"}, true);
        mf.verifyAcknowledgements(new boolean[5], true);
        mf.verifyMessages(3, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction()};
        mf.verifyActions(expectedActions, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true}, false);
    }

    void verifyStorePopulation() {
        RMManager manager = (RMManager)this.bus.getExtension(RMManager.class);
        ClientPersistenceTest.assertNotNull((Object)manager);
        RMStore store = manager.getStore();
        ClientPersistenceTest.assertNotNull((Object)store);
        Client client = ClientProxy.getClient((Object)this.greeter);
        String id = RMUtils.getEndpointIdentifier((Endpoint)client.getEndpoint());
        Collection dss = store.getDestinationSequences(id);
        ClientPersistenceTest.assertEquals((Object)1, (Object)dss.size());
        Collection sss = store.getSourceSequences(id);
        ClientPersistenceTest.assertEquals((Object)1, (Object)sss.size());
        Collection msgs = store.getMessages(((SourceSequence)sss.iterator().next()).getIdentifier(), true);
        ClientPersistenceTest.assertEquals((Object)2, (Object)msgs.size());
        msgs = store.getMessages(((SourceSequence)sss.iterator().next()).getIdentifier(), false);
        ClientPersistenceTest.assertEquals((Object)0, (Object)msgs.size());
    }

    void stopClient() {
        this.bus.shutdown(true);
    }

    void recover() throws Exception {
        Thread.sleep(5000L);
        LOG.info("Recovered messages should have been resent by now.");
    }

    void verifyRecovery() throws Exception {
        RMManager manager = (RMManager)this.bus.getExtension(RMManager.class);
        ClientPersistenceTest.assertNotNull((Object)manager);
        RMStore store = manager.getStore();
        ClientPersistenceTest.assertNotNull((Object)store);
        Client client = ClientProxy.getClient((Object)this.greeter);
        String id = RMUtils.getEndpointIdentifier((Endpoint)client.getEndpoint());
        Collection dss = store.getDestinationSequences(id);
        ClientPersistenceTest.assertEquals((Object)1, (Object)dss.size());
        Collection sss = store.getSourceSequences(id);
        ClientPersistenceTest.assertEquals((Object)1, (Object)sss.size());
        for (int i = 0; store.getMessages(((SourceSequence)sss.iterator().next()).getIdentifier(), true).size() > 0 && i < 10; ++i) {
            Thread.sleep(200L);
        }
        ClientPersistenceTest.assertEquals((Object)0, (Object)store.getMessages(((SourceSequence)sss.iterator().next()).getIdentifier(), true).size());
        ClientPersistenceTest.assertEquals((Object)0, (Object)store.getMessages(((SourceSequence)sss.iterator().next()).getIdentifier(), false).size());
    }

    private void awaitMessages(int nExpectedOut, int nExpectedIn) {
        this.awaitMessages(nExpectedOut, nExpectedIn, 10000);
    }

    private void awaitMessages(int nExpectedOut, int nExpectedIn, int timeout) {
        MessageRecorder mr = new MessageRecorder(this.out, this.in);
        mr.awaitMessages(nExpectedOut, nExpectedIn, timeout);
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("/org/apache/cxf/systest/ws/rm/persistent.xml");
            BusFactory.setDefaultBus((Bus)bus);
            LoggingInInterceptor logIn = new LoggingInInterceptor();
            bus.getInInterceptors().add(logIn);
            LoggingOutInterceptor logOut = new LoggingOutInterceptor();
            bus.getOutFaultInterceptors().add(logOut);
            bus.getOutFaultInterceptors().add(logOut);
            ((RMManager)bus.getExtension(RMManager.class)).getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("60000"));
            GreeterImpl implementor = new GreeterImpl();
            String address = "http://localhost:9020/SoapContext/GreeterPort";
            javax.xml.ws.Endpoint ep = javax.xml.ws.Endpoint.create((Object)((Object)implementor));
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("schema-validation-enabled", Boolean.TRUE);
            ep.setProperties(properties);
            ep.publish(address);
            LOG.info("Published greeter endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                RMTxStore.deleteDatabaseFiles();
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

