/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.rm;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.hello_world_soap_http.DocLitBare;
import org.apache.hello_world_soap_http.DocLitBareGreeterImpl;
import org.apache.hello_world_soap_http.SOAPServiceAddressingDocLitBare;
import org.apache.hello_world_soap_http.types.BareDocumentResponse;
import org.junit.BeforeClass;
import org.junit.Test;

public class DecoupledBareTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(DecoupledBareTest.class);

    @BeforeClass
    public static void startServers() throws Exception {
        DecoupledBareTest.assertTrue((String)"server did not launch correctly", (boolean)DecoupledBareTest.launchServer(Server.class));
    }

    @Test
    public void testDecoupled() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus("/org/apache/cxf/systest/ws/rm/decoupled_bare.xml");
        BusFactory.setDefaultBus((Bus)this.bus);
        SOAPServiceAddressingDocLitBare service = new SOAPServiceAddressingDocLitBare();
        DecoupledBareTest.assertNotNull((Object)service);
        DocLitBare greeter = service.getSoapPort();
        ((BindingProvider)greeter).getRequestContext().put("schema-validation-enabled", Boolean.TRUE);
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        BareDocumentResponse bareres = greeter.testDocLitBare("MySimpleDocument");
        DecoupledBareTest.assertNotNull((String)"no response for operation testDocLitBare", (Object)bareres);
        DecoupledBareTest.assertEquals((Object)"CXF", (Object)bareres.getCompany());
        DecoupledBareTest.assertTrue((bareres.getId() == 1 ? 1 : 0) != 0);
    }

    public static class Server
    extends AbstractBusTestServerBase {
        protected void run() {
            SpringBusFactory bf = new SpringBusFactory();
            Bus bus = bf.createBus("/org/apache/cxf/systest/ws/rm/decoupled_bare.xml");
            BusFactory.setDefaultBus((Bus)bus);
            DocLitBareGreeterImpl implementor = new DocLitBareGreeterImpl();
            String address = "http://localhost:7600/SoapContext/SoapPort";
            Endpoint ep = Endpoint.create((Object)implementor);
            HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
            properties.put("schema-validation-enabled", Boolean.TRUE);
            ep.setProperties(properties);
            ep.publish(address);
            LOG.info("Published server endpoint.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void main(String[] args) {
            try {
                Server s = new Server();
                s.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            finally {
                System.out.println("done!");
            }
        }
    }
}

