/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.rm;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.Control;
import org.apache.cxf.greeter_control.ControlService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.systest.ws.rm.MessageLossSimulator;
import org.apache.cxf.systest.ws.rm.Server;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.systest.ws.util.InMessageRecorder;
import org.apache.cxf.systest.ws.util.MessageFlow;
import org.apache.cxf.systest.ws.util.MessageRecorder;
import org.apache.cxf.systest.ws.util.OutMessageRecorder;
import org.apache.cxf.test.TestUtilities;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMInInterceptor;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMOutInterceptor;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.soap.RMSoapInterceptor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceTest
extends AbstractBusClientServerTestBase {
    private static final Logger LOG = LogUtils.getLogger(SequenceTest.class);
    private static final String GREETMEONEWAY_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeOneWayRequest";
    private static final String GREETME_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeRequest";
    private static final String GREETME_RESPONSE_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeResponse";
    private static int decoupledEndpointPort = 10000;
    private static String decoupledEndpoint;
    private Bus controlBus;
    private Control control;
    private Bus greeterBus;
    private Greeter greeter;
    private OutMessageRecorder outRecorder;
    private InMessageRecorder inRecorder;

    @BeforeClass
    public static void startServers() throws Exception {
        TestUtilities.setKeepAliveSystemProperty((boolean)false);
        SequenceTest.assertTrue((String)"server did not launch correctly", (boolean)SequenceTest.launchServer(Server.class));
    }

    @AfterClass
    public static void cleanup() {
        TestUtilities.recoverKeepAliveSystemProperty();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.stopGreeter();
            this.stopControl();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Thread.sleep(100L);
    }

    @Test
    @Ignore
    public void testRMServerPlainClient() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.controlBus = bf.createBus();
        BusFactory.setDefaultBus((Bus)this.controlBus);
        ControlService cs = new ControlService();
        this.control = cs.getControlPort();
        SequenceTest.assertTrue((String)"Failed to start greeter", (boolean)this.control.startGreeter("org/apache/cxf/systest/ws/rm/rminterceptors.xml"));
        this.greeterBus = bf.createBus("org/apache/cxf/systest/ws/rm/rminterceptors.xml");
        BusFactory.setDefaultBus((Bus)this.greeterBus);
        this.removeRMInterceptors(this.greeterBus.getOutInterceptors());
        this.removeRMInterceptors(this.greeterBus.getOutFaultInterceptors());
        this.removeRMInterceptors(this.greeterBus.getInInterceptors());
        this.removeRMInterceptors(this.greeterBus.getInFaultInterceptors());
        LOG.fine("Initialised greeter bus with addressing but without RM interceptors");
        this.outRecorder = new OutMessageRecorder();
        this.greeterBus.getOutInterceptors().add(this.outRecorder);
        this.inRecorder = new InMessageRecorder();
        this.greeterBus.getInInterceptors().add(this.inRecorder);
        GreeterService gs = new GreeterService();
        this.greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(this.greeter, true);
        this.greeter.greetMeOneWay("once");
    }

    @Test
    public void testOnewayAnonymousAcks() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/rminterceptors.xml");
        this.greeter.greetMeOneWay("once");
        this.greeter.greetMeOneWay("twice");
        this.greeter.greetMeOneWay("thrice");
        this.awaitMessages(4, 4);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(4, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
        mf.verifyMessages(4, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction()};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, null, null, null}, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true, true}, false);
    }

    @Test
    public void testOnewayDeferredAnonymousAcks() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/deferred.xml");
        this.greeter.greetMeOneWay("once");
        this.greeter.greetMeOneWay("twice");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.greeter.greetMeOneWay("thrice");
        this.awaitMessages(4, 4);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(4, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
        mf.verifyMessages(4, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), null, null, RMConstants.getSequenceAcknowledgmentAction()};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, null, null, null}, false);
        mf.verifyAcknowledgements(new boolean[]{false, false, false, true}, false);
    }

    @Test
    public void testOnewayDeferredNonAnonymousAcks() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/deferred.xml", true);
        this.greeter.greetMeOneWay("once");
        this.greeter.greetMeOneWay("twice");
        this.awaitMessages(3, 4);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(3, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2"}, true);
        mf.verifyMessages(4, false);
        mf.verifyMessageNumbers(new String[4], false);
        mf.verifyAcknowledgements(new boolean[4], false);
        mf.verifyPartialResponses(3);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction()};
        mf.verifyActionsIgnoringPartialResponses(expectedActions);
        mf.purge();
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.awaitMessages(0, 1);
        mf.reset(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(0, true);
        mf.verifyMessages(1, false);
        mf.verifyAcknowledgements(new boolean[]{true}, false);
    }

    @Test
    public void testOnewayAnonymousAcksSequenceLength1() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/seqlength1.xml");
        this.greeter.greetMeOneWay("once");
        this.greeter.greetMeOneWay("twice");
        this.awaitMessages(6, 6);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(6, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, RMConstants.getTerminateSequenceAction(), RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, RMConstants.getTerminateSequenceAction()};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", null, null, "1", null}, true);
        mf.verifyLastMessage(new boolean[]{false, true, false, false, true, false}, true);
        mf.verifyMessages(6, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAcknowledgmentAction(), null, RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAcknowledgmentAction(), null};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, null, null, null, null, null}, false);
        mf.verifyLastMessage(new boolean[]{false, false, false, false, false, false}, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, false, false, true, false}, false);
    }

    @Test
    public void testOnewayAnonymousAcksSuppressed() throws Exception {
        this.testOnewayAnonymousAcksSuppressed(null);
    }

    @Test
    public void testOnewayAnonymousAcksSuppressedAsyncExecutor() throws Exception {
        this.testOnewayAnonymousAcksSuppressed(Executors.newSingleThreadExecutor());
    }

    private void testOnewayAnonymousAcksSuppressed(Executor executor) throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/suppressed.xml", false, executor);
        this.greeter.greetMeOneWay("once");
        this.greeter.greetMeOneWay("twice");
        this.greeter.greetMeOneWay("thrice");
        this.awaitMessages(4, 4, 2000);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(4, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
        mf.verifyMessages(4, false);
        mf.verifyPartialResponses(3, new boolean[3]);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction()};
        mf.verifyActions(expectedActions, false);
        mf.purge();
        SequenceTest.assertEquals((Object)0, (Object)this.outRecorder.getOutboundMessages().size());
        SequenceTest.assertEquals((Object)0, (Object)this.inRecorder.getInboundMessages().size());
        this.awaitMessages(3, 0, 7500);
    }

    @Test
    public void testTwowayNonAnonymous() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/rminterceptors.xml", true);
        SequenceTest.assertEquals((Object)"ONE", (Object)this.greeter.greetMe("one"));
        SequenceTest.assertEquals((Object)"TWO", (Object)this.greeter.greetMe("two"));
        SequenceTest.assertEquals((Object)"THREE", (Object)this.greeter.greetMe("three"));
        this.awaitMessages(4, 8);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(4, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION, GREETME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
        mf.verifyLastMessage(new boolean[]{false, false, false, false}, true);
        mf.verifyAcknowledgements(new boolean[]{false, false, true, true}, true);
        mf.verifyMessages(8, false);
        mf.verifyPartialResponses(4, new boolean[4]);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, false);
        mf.verifyLastMessage(new boolean[4], false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true, true}, false);
    }

    @Test
    public void testTwowayNonAnonymousEndpointSpecific() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/twoway-endpoint-specific.xml", true);
        this.greeter.greetMe("one");
        this.greeter.greetMe("two");
        this.greeter.greetMe("three");
        this.awaitMessages(4, 8);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(4, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION, GREETME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
        mf.verifyLastMessage(new boolean[]{false, false, false, false}, true);
        mf.verifyAcknowledgements(new boolean[]{false, false, true, true}, true);
        mf.verifyMessages(8, false);
        mf.verifyPartialResponses(4, new boolean[4]);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, false);
        mf.verifyLastMessage(new boolean[4], false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true, true}, false);
    }

    @Test
    public void testTwowayNonAnonymousDeferred() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/deferred.xml", true);
        this.greeter.greetMe("one");
        this.greeter.greetMe("two");
        this.awaitMessages(3, 6);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(3, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2"}, true);
        mf.verifyLastMessage(new boolean[3], true);
        mf.verifyAcknowledgements(new boolean[3], true);
        mf.verifyMessages(6, false);
        mf.verifyLastMessage(new boolean[6], false);
        mf.verifyAcknowledgements(new boolean[6], false);
        mf.verifyPartialResponses(3);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2"}, false);
        mf.purge();
        this.awaitMessages(1, 0);
        mf.reset(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessageNumbers(new String[1], true);
        mf.verifyLastMessage(new boolean[1], true);
        mf.verifyAcknowledgements(new boolean[]{true}, true);
    }

    @Test
    public void testTwowayNonAnonymousMaximumSequenceLength2() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/seqlength10.xml", true);
        RMManager manager = (RMManager)this.greeterBus.getExtension(RMManager.class);
        SequenceTest.assertEquals((String)"Unexpected maximum sequence length.", (Object)BigInteger.TEN, (Object)manager.getSourcePolicy().getSequenceTerminationPolicy().getMaxLength());
        manager.getSourcePolicy().getSequenceTerminationPolicy().setMaxLength(new BigInteger("2"));
        this.greeter.greetMe("one");
        this.greeter.greetMe("two");
        this.greeter.greetMe("three");
        this.awaitMessages(7, 13, 5000);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(7, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION, RMConstants.getTerminateSequenceAction(), RMConstants.getSequenceAckAction(), RMConstants.getCreateSequenceAction(), GREETME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", null, null, null, "1"}, true);
        mf.verifyLastMessage(new boolean[]{false, false, true, false, false, false, false}, true);
        mf.verifyAcknowledgements(new boolean[]{false, false, true, false, true, false, false}, true);
        mf.verifyMessages(13, false);
        mf.verifyPartialResponses(7);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION, RMConstants.getTerminateSequenceAction(), RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", null, null, "1"}, false);
        boolean[] expected = new boolean[6];
        expected[2] = true;
        mf.verifyLastMessage(expected, false);
        expected[1] = true;
        expected[5] = true;
        mf.verifyAcknowledgements(expected, false);
    }

    @Test
    public void testTwowayAtMostOnce() throws Exception {
        this.doTestTwowayNoDuplicates("org/apache/cxf/systest/ws/rm/atmostonce.xml");
    }

    @Test
    public void testTwowayExactlyOnce() throws Exception {
        this.doTestTwowayNoDuplicates("org/apache/cxf/systest/ws/rm/exactlyonce.xml");
    }

    private void doTestTwowayNoDuplicates(String cfg) throws Exception {
        this.init(cfg);
        class MessageNumberInterceptor
        extends AbstractPhaseInterceptor {
            public MessageNumberInterceptor() {
                super("user-logical");
            }

            public void handleMessage(Message m) {
                RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)m, (boolean)true);
                if (null != rmps && null != rmps.getSequence()) {
                    rmps.getSequence().setMessageNumber(BigInteger.ONE);
                }
            }
        }
        this.greeterBus.getOutInterceptors().add(new MessageNumberInterceptor());
        RMManager manager = (RMManager)this.greeterBus.getExtension(RMManager.class);
        manager.getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("2000"));
        this.greeter.greetMe("one");
        try {
            this.greeter.greetMe("two");
            SequenceTest.fail((String)"Expected fault.");
        }
        catch (WebServiceException ex) {
            SoapFault sf = (SoapFault)ex.getCause();
            SequenceTest.assertEquals((String)"Unexpected fault code.", (Object)Soap11.getInstance().getReceiver(), (Object)sf.getFaultCode());
            SequenceTest.assertNull((String)"Unexpected sub code.", (Object)sf.getSubCode());
            SequenceTest.assertTrue((String)"Unexpected reason.", (boolean)sf.getReason().endsWith("has already been delivered."));
        }
        this.awaitMessages(3, 3, 5000);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        String[] expectedActions = new String[3];
        expectedActions[0] = RMConstants.getCreateSequenceAction();
        for (int i = 1; i < expectedActions.length; ++i) {
            expectedActions[i] = GREETME_ACTION;
        }
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "1"}, true);
        mf.verifyLastMessage(new boolean[3], true);
        mf.verifyAcknowledgements(new boolean[3], true);
        mf.verifyMessages(3, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, null};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", null}, false);
        mf.verifyAcknowledgements(new boolean[3], false);
    }

    @Test
    public void testUnknownSequence() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/rminterceptors.xml");
        class SequenceIdInterceptor
        extends AbstractPhaseInterceptor {
            public SequenceIdInterceptor() {
                super("user-logical");
            }

            public void handleMessage(Message m) {
                RMProperties rmps = RMContextUtils.retrieveRMProperties((Message)m, (boolean)true);
                if (null != rmps && null != rmps.getSequence()) {
                    rmps.getSequence().getIdentifier().setValue("UNKNOWN");
                }
            }
        }
        this.greeterBus.getOutInterceptors().add(new SequenceIdInterceptor());
        RMManager manager = (RMManager)this.greeterBus.getExtension(RMManager.class);
        manager.getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("2000"));
        try {
            this.greeter.greetMe("one");
            SequenceTest.fail((String)"Expected fault.");
        }
        catch (WebServiceException ex) {
            SoapFault sf = (SoapFault)ex.getCause();
            SequenceTest.assertEquals((String)"Unexpected fault code.", (Object)Soap11.getInstance().getSender(), (Object)sf.getFaultCode());
            SequenceTest.assertNull((String)"Unexpected sub code.", (Object)sf.getSubCode());
            SequenceTest.assertTrue((String)"Unexpected reason.", (boolean)sf.getReason().endsWith("is not a known Sequence identifier."));
        }
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifySequenceFault(RMConstants.getUnknownSequenceFaultCode(), false, 1);
    }

    @Test
    public void testInactivityTimeout() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/inactivity-timeout.xml");
        this.greeter.greetMe("one");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            this.greeter.greetMe("two");
            SequenceTest.fail((String)"Expected fault.");
        }
        catch (WebServiceException ex) {
            SoapFault sf = (SoapFault)ex.getCause();
            SequenceTest.assertEquals((String)"Unexpected fault code.", (Object)Soap11.getInstance().getSender(), (Object)sf.getFaultCode());
            SequenceTest.assertNull((String)"Unexpected sub code.", (Object)sf.getSubCode());
            SequenceTest.assertTrue((String)"Unexpected reason.", (boolean)sf.getReason().endsWith("is not a known Sequence identifier."));
        }
        this.awaitMessages(3, 3, 5000);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        String[] expectedActions = new String[3];
        expectedActions[0] = RMConstants.getCreateSequenceAction();
        for (int i = 1; i < expectedActions.length; ++i) {
            expectedActions[i] = GREETME_ACTION;
        }
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2"}, true);
        mf.verifyLastMessage(new boolean[3], true);
        mf.verifyAcknowledgements(new boolean[]{false, false, false}, true);
        mf.verifyMessages(3, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, null};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", null}, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, false}, false);
        mf.verifySequenceFault(RMConstants.getUnknownSequenceFaultCode(), false, 2);
    }

    @Test
    public void testOnewayMessageLoss() throws Exception {
        Thread.sleep(5000L);
        this.testOnewayMessageLoss(null);
    }

    @Test
    public void testOnewayMessageLossAsyncExecutor() throws Exception {
        this.testOnewayMessageLoss(Executors.newSingleThreadExecutor());
    }

    private void testOnewayMessageLoss(Executor executor) throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/message-loss.xml", false, executor);
        this.greeterBus.getOutInterceptors().add(new MessageLossSimulator());
        RMManager manager = (RMManager)this.greeterBus.getExtension(RMManager.class);
        manager.getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("2000"));
        this.greeter.greetMeOneWay("one");
        this.greeter.greetMeOneWay("two");
        this.greeter.greetMeOneWay("three");
        this.greeter.greetMeOneWay("four");
        this.awaitMessages(7, 5, 10000);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        String[] expectedActions = new String[7];
        expectedActions[0] = RMConstants.getCreateSequenceAction();
        for (int i = 1; i < expectedActions.length; ++i) {
            expectedActions[i] = GREETMEONEWAY_ACTION;
        }
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3", "4", "2", "4"}, true, false);
        mf.verifyLastMessage(new boolean[7], true);
        mf.verifyAcknowledgements(new boolean[7], true);
        mf.verifyMessages(5, false);
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction()};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, null, null, null, null}, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true, true, true}, false);
    }

    @Test
    public void testTwowayMessageLoss() throws Exception {
        this.testTwowayMessageLoss(null);
    }

    @Test
    public void testTwowayMessageLossAsyncExecutor() throws Exception {
        this.testTwowayMessageLoss(Executors.newSingleThreadExecutor());
    }

    private void testTwowayMessageLoss(Executor executor) throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/message-loss.xml", true, executor);
        this.greeterBus.getOutInterceptors().add(new MessageLossSimulator());
        RMManager manager = (RMManager)this.greeterBus.getExtension(RMManager.class);
        manager.getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("2000"));
        this.greeter.greetMe("one");
        this.greeter.greetMe("two");
        this.greeter.greetMe("three");
        this.greeter.greetMe("four");
        this.awaitMessages(7, 10, 10000);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        String[] expectedActions = new String[7];
        expectedActions[0] = RMConstants.getCreateSequenceAction();
        for (int i = 1; i < expectedActions.length; ++i) {
            expectedActions[i] = GREETME_ACTION;
        }
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "2", "3", "4", "4"}, true);
        mf.verifyLastMessage(new boolean[7], true);
        boolean[] expectedAcks = new boolean[7];
        for (int i = 2; i < expectedAcks.length; ++i) {
            expectedAcks[i] = true;
        }
        mf.verifyAcknowledgements(expectedAcks, true);
        mf.verifyPartialResponses(5);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3", "4"}, false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true, true, true}, false);
    }

    @Test
    public void testTwowayNonAnonymousNoOffer() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/no-offer.xml", true);
        this.greeter.greetMe("one");
        this.awaitMessages(3, 6);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(3, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, RMConstants.getCreateSequenceResponseAction()};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", null}, true);
        mf.verifyLastMessage(new boolean[]{false, false, false}, true);
        mf.verifyAcknowledgements(new boolean[]{false, false, false}, true);
        mf.verifyPartialResponses(3, new boolean[3]);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getCreateSequenceAction(), GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, null, "1"}, false);
        mf.verifyAcknowledgements(new boolean[]{false, false, false}, false);
    }

    @Test
    public void testConcurrency() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/rminterceptors.xml", true);
        int max = 5;
        for (int i = 0; i < max; ++i) {
            this.greeter.greetMeAsync(Integer.toString(i));
        }
        this.awaitMessages(max + 1, max * 2 + 1, 7500);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(max + 1, true);
        String[] expectedActions = new String[max + 1];
        expectedActions[0] = RMConstants.getCreateSequenceAction();
        for (int i = 1; i < expectedActions.length; ++i) {
            expectedActions[i] = GREETME_ACTION;
        }
        mf.verifyActions(expectedActions, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiClientOneway() throws Exception {
        int i;
        SpringBusFactory bf = new SpringBusFactory();
        String cfgResource = "org/apache/cxf/systest/ws/rm/rminterceptors.xml";
        this.initControl(bf, cfgResource);
        class ClientThread
        extends Thread {
            Greeter greeter;
            Bus greeterBus;
            InMessageRecorder inRecorder;
            OutMessageRecorder outRecorder;
            String id;

            ClientThread(SpringBusFactory bf, String cfgResource, int n) {
                SequenceTest.this.initGreeter(bf, cfgResource, false, null);
                this.greeter = SequenceTest.this.greeter;
                this.greeterBus = SequenceTest.this.greeterBus;
                this.inRecorder = SequenceTest.this.inRecorder;
                this.outRecorder = SequenceTest.this.outRecorder;
                this.id = "client " + n;
            }

            public void run() {
                this.greeter.greetMeOneWay(this.id + ": once");
                this.greeter.greetMeOneWay(this.id + ": twice");
                this.greeter.greetMeOneWay(this.id + ": thrice");
                SequenceTest.this.awaitMessages(4, 4);
            }
        }
        ClientThread[] clients = new ClientThread[2];
        try {
            for (i = 0; i < clients.length; ++i) {
                clients[i] = new ClientThread(bf, cfgResource, i);
            }
            for (i = 0; i < clients.length; ++i) {
                clients[i].start();
            }
            for (i = 0; i < clients.length; ++i) {
                clients[i].join();
                MessageFlow mf = new MessageFlow(clients[i].outRecorder.getOutboundMessages(), clients[i].inRecorder.getInboundMessages());
                mf.verifyMessages(4, true);
                String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION};
                mf.verifyActions(expectedActions, true);
                mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
                mf.verifyMessages(4, false);
                expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction(), RMConstants.getSequenceAcknowledgmentAction()};
                mf.verifyActions(expectedActions, false);
                mf.verifyMessageNumbers(new String[]{null, null, null, null}, false);
                mf.verifyAcknowledgements(new boolean[]{false, true, true, true}, false);
            }
        }
        catch (Throwable throwable) {
            for (int i2 = 0; i2 < clients.length; ++i2) {
                this.greeter = clients[i2].greeter;
                this.greeterBus = clients[i2].greeterBus;
                this.stopGreeter();
            }
            this.greeter = null;
            throw throwable;
        }
        for (i = 0; i < clients.length; ++i) {
            this.greeter = clients[i].greeter;
            this.greeterBus = clients[i].greeterBus;
            this.stopGreeter();
        }
        this.greeter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiClientTwoway() throws Exception {
        int i;
        SpringBusFactory bf = new SpringBusFactory();
        String cfgResource = "org/apache/cxf/systest/ws/rm/rminterceptors.xml";
        this.initControl(bf, cfgResource);
        class ClientThread
        extends Thread {
            Greeter greeter;
            Bus greeterBus;
            InMessageRecorder inRecorder;
            OutMessageRecorder outRecorder;
            String id;

            ClientThread(SpringBusFactory bf, String cfgResource, int n) {
                SequenceTest.this.initGreeter(bf, cfgResource, true, null);
                this.greeter = SequenceTest.this.greeter;
                this.greeterBus = SequenceTest.this.greeterBus;
                this.inRecorder = SequenceTest.this.inRecorder;
                this.outRecorder = SequenceTest.this.outRecorder;
                this.id = "client " + n;
            }

            public void run() {
                this.greeter.greetMe(this.id + ": a");
                this.greeter.greetMe(this.id + ": b");
                this.greeter.greetMe(this.id + ": c");
                SequenceTest.this.awaitMessages(4, 8);
            }
        }
        ClientThread[] clients = new ClientThread[2];
        try {
            for (i = 0; i < clients.length; ++i) {
                clients[i] = new ClientThread(bf, cfgResource, i);
            }
            for (i = 0; i < clients.length; ++i) {
                clients[i].start();
            }
            for (i = 0; i < clients.length; ++i) {
                clients[i].join();
                MessageFlow mf = new MessageFlow(clients[i].outRecorder.getOutboundMessages(), clients[i].inRecorder.getInboundMessages());
                mf.verifyMessages(4, true);
                String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION, GREETME_ACTION};
                mf.verifyActions(expectedActions, true);
                mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, true);
                mf.verifyLastMessage(new boolean[]{false, false, false, false}, true);
                mf.verifyAcknowledgements(new boolean[]{false, false, true, true}, true);
                mf.verifyMessages(8, false);
                mf.verifyPartialResponses(4, new boolean[4]);
                mf.purgePartialResponses();
                expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
                mf.verifyActions(expectedActions, false);
                mf.verifyMessageNumbers(new String[]{null, "1", "2", "3"}, false);
                mf.verifyLastMessage(new boolean[4], false);
                mf.verifyAcknowledgements(new boolean[]{false, true, true, true}, false);
            }
        }
        catch (Throwable throwable) {
            for (int i2 = 0; i2 < clients.length; ++i2) {
                this.greeter = clients[i2].greeter;
                this.greeterBus = clients[i2].greeterBus;
                this.stopGreeter();
            }
            this.greeter = null;
            throw throwable;
        }
        for (i = 0; i < clients.length; ++i) {
            this.greeter = clients[i].greeter;
            this.greeterBus = clients[i].greeterBus;
            this.stopGreeter();
        }
        this.greeter = null;
    }

    @Test
    public void testServerSideMessageLoss() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/message-loss-server.xml", true);
        List outInterceptors = this.greeterBus.getOutInterceptors();
        for (Interceptor i : outInterceptors) {
            if (!i.getClass().equals(MessageLossSimulator.class)) continue;
            outInterceptors.remove(i);
            break;
        }
        ((RMManager)this.greeterBus.getExtension(RMManager.class)).getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("60000"));
        this.greeter.greetMe("one");
        this.greeter.greetMe("two");
        this.awaitMessages(3, 6);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(3, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2"}, true);
        mf.verifyLastMessage(new boolean[]{false, false, false}, true);
        mf.verifyAcknowledgements(new boolean[]{false, false, true}, true);
        mf.verifyMessages(6, false);
        mf.verifyPartialResponses(3, new boolean[3]);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
        mf.verifyMessageNumbers(new String[]{null, "1", "2"}, false);
        mf.verifyLastMessage(new boolean[3], false);
        mf.verifyAcknowledgements(new boolean[]{false, true, true}, false);
    }

    @Test
    public void testTerminateOnShutdown() throws Exception {
        this.init("org/apache/cxf/systest/ws/rm/terminate-on-shutdown.xml", true);
        this.greeter.greetMeOneWay("neutrophil");
        this.greeter.greetMeOneWay("basophil");
        this.greeter.greetMeOneWay("eosinophil");
        this.stopGreeterButNotCloseConduit();
        this.awaitMessages(6, 8);
        MessageFlow mf = new MessageFlow(this.outRecorder.getOutboundMessages(), this.inRecorder.getInboundMessages());
        mf.verifyMessages(6, true);
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, GREETMEONEWAY_ACTION, RMConstants.getLastMessageAction(), RMConstants.getTerminateSequenceAction()};
        mf.verifyActions(expectedActions, true);
        mf.verifyMessageNumbers(new String[]{null, "1", "2", "3", "4", null}, true);
        mf.verifyMessages(8, false);
        mf.verifyMessageNumbers(new String[8], false);
        mf.verifyPartialResponses(6);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), RMConstants.getSequenceAckAction()};
        mf.verifyActions(expectedActions, false);
        mf.verifyAcknowledgements(new boolean[]{false, true}, false);
    }

    private void init(String cfgResource) {
        this.init(cfgResource, false);
    }

    private void init(String cfgResource, boolean useDecoupledEndpoint) {
        this.init(cfgResource, useDecoupledEndpoint, null);
    }

    private void init(String cfgResource, boolean useDecoupledEndpoint, Executor executor) {
        SpringBusFactory bf = new SpringBusFactory();
        this.initControl(bf, cfgResource);
        this.initGreeter(bf, cfgResource, useDecoupledEndpoint, executor);
    }

    private void initControl(SpringBusFactory bf, String cfgResource) {
        this.controlBus = bf.createBus();
        BusFactory.setDefaultBus((Bus)this.controlBus);
        ControlService cs = new ControlService();
        this.control = cs.getControlPort();
        SequenceTest.assertTrue((String)"Failed to start greeter", (boolean)this.control.startGreeter(cfgResource));
    }

    private void initGreeter(SpringBusFactory bf, String cfgResource, boolean useDecoupledEndpoint, Executor executor) {
        this.greeterBus = bf.createBus(cfgResource);
        BusFactory.setDefaultBus((Bus)this.greeterBus);
        LOG.fine("Initialised greeter bus with configuration: " + cfgResource);
        this.outRecorder = new OutMessageRecorder();
        this.greeterBus.getOutInterceptors().add(this.outRecorder);
        this.inRecorder = new InMessageRecorder();
        this.greeterBus.getInInterceptors().add(this.inRecorder);
        GreeterService gs = new GreeterService();
        if (null != executor) {
            gs.setExecutor(executor);
        }
        this.greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(this.greeter, true);
        if (!useDecoupledEndpoint) {
            return;
        }
        decoupledEndpoint = "http://localhost:" + --decoupledEndpointPort + "/decoupled_endpoint";
        Client c = ClientProxy.getClient((Object)this.greeter);
        HTTPConduit hc = (HTTPConduit)c.getConduit();
        HTTPClientPolicy cp = hc.getClient();
        cp.setDecoupledEndpoint(decoupledEndpoint);
        LOG.fine("Using decoupled endpoint: " + cp.getDecoupledEndpoint());
    }

    private void stopGreeter() {
        if (null != this.greeterBus) {
            ClientProxy.getClient((Object)this.greeter).getConduit().close();
            this.greeterBus.shutdown(true);
            this.greeter = null;
            this.greeterBus = null;
        }
    }

    private void stopControl() {
        if (null != this.control) {
            SequenceTest.assertTrue((String)"Failed to stop greeter", (boolean)this.control.stopGreeter(null));
            this.controlBus.shutdown(true);
        }
    }

    private void stopGreeterButNotCloseConduit() {
        if (null != this.greeterBus) {
            this.greeterBus.shutdown(true);
            this.greeter = null;
            this.greeterBus = null;
        }
    }

    private void awaitMessages(int nExpectedOut, int nExpectedIn) {
        this.awaitMessages(nExpectedOut, nExpectedIn, 10000);
    }

    private void awaitMessages(int nExpectedOut, int nExpectedIn, int timeout) {
        MessageRecorder mr = new MessageRecorder(this.outRecorder, this.inRecorder);
        mr.awaitMessages(nExpectedOut, nExpectedIn, timeout);
    }

    private void removeRMInterceptors(List<Interceptor> interceptors) {
        Iterator<Interceptor> it = interceptors.iterator();
        while (it.hasNext()) {
            Interceptor i = it.next();
            if (!(i instanceof RMSoapInterceptor) && !(i instanceof RMOutInterceptor) && !(i instanceof RMInInterceptor)) continue;
            it.remove();
        }
    }
}

