/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.rm;

import java.math.BigInteger;
import java.util.logging.Logger;
import javax.xml.ws.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.greeter_control.Control;
import org.apache.cxf.greeter_control.ControlService;
import org.apache.cxf.greeter_control.Greeter;
import org.apache.cxf.greeter_control.GreeterService;
import org.apache.cxf.greeter_control.types.GreetMeResponse;
import org.apache.cxf.systest.ws.rm.Server;
import org.apache.cxf.systest.ws.util.ConnectionHelper;
import org.apache.cxf.systest.ws.util.InMessageRecorder;
import org.apache.cxf.systest.ws.util.MessageFlow;
import org.apache.cxf.systest.ws.util.MessageRecorder;
import org.apache.cxf.systest.ws.util.OutMessageRecorder;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.persistence.jdbc.RMTxStore;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerPersistenceTest
extends AbstractBusClientServerTestBase {
    public static final String GREETMEONEWAY_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeOneWayRequest";
    public static final String GREETME_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeRequest";
    private static final String GREETME_RESPONSE_ACTION = "http://cxf.apache.org/greeter_control/Greeter/greetMeResponse";
    private static final Logger LOG = LogUtils.getLogger(ServerPersistenceTest.class);
    private static final String CFG = "/org/apache/cxf/systest/ws/rm/persistent.xml";
    private static final String SERVER_LOSS_CFG = "/org/apache/cxf/systest/ws/rm/persistent-message-loss-server.xml";
    private OutMessageRecorder out;
    private InMessageRecorder in;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void startServers() throws Exception {
        RMTxStore.deleteDatabaseFiles();
        String derbyHome = System.getProperty("derby.system.home");
        try {
            System.setProperty("derby.system.home", derbyHome + "-server");
            RMTxStore.deleteDatabaseFiles();
        }
        finally {
            if (derbyHome != null) {
                System.setProperty("derby.system.home", derbyHome);
            } else {
                System.clearProperty("derby.system.home");
            }
        }
        boolean inProcess = "Windows 2000".equals(System.getProperty("os.name"));
        ServerPersistenceTest.assertTrue((String)"server did not launch correctly", (boolean)ServerPersistenceTest.launchServer(Server.class, (boolean)inProcess));
    }

    @Test
    public void testRecovery() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        this.bus = bf.createBus();
        BusFactory.setDefaultBus((Bus)this.bus);
        LOG.fine("Created bus " + this.bus + " with default cfg");
        ControlService cs = new ControlService();
        Control control = cs.getControlPort();
        ServerPersistenceTest.assertTrue((String)"Failed to start greeter", (boolean)control.startGreeter(SERVER_LOSS_CFG));
        LOG.fine("Started greeter server.");
        Bus greeterBus = new SpringBusFactory().createBus(CFG);
        LOG.fine("Created bus " + greeterBus + " with cfg : " + CFG);
        BusFactory.setDefaultBus((Bus)greeterBus);
        ((RMManager)greeterBus.getExtension(RMManager.class)).getRMAssertion().getBaseRetransmissionInterval().setMilliseconds(new BigInteger("60000"));
        GreeterService gs = new GreeterService();
        Greeter greeter = gs.getGreeterPort();
        LOG.fine("Created greeter client.");
        ConnectionHelper.setKeepAliveConnection(greeter, true);
        Client c = ClientProxy.getClient((Object)greeter);
        HTTPConduit hc = (HTTPConduit)c.getConduit();
        HTTPClientPolicy cp = hc.getClient();
        cp.setDecoupledEndpoint("http://localhost:9994/decoupled_endpoint");
        this.out = new OutMessageRecorder();
        this.in = new InMessageRecorder();
        greeterBus.getOutInterceptors().add(this.out);
        greeterBus.getInInterceptors().add(this.in);
        LOG.fine("Configured greeter client.");
        Response<T>[] responses = this.cast(new Response[3]);
        responses[0] = greeter.greetMeAsync("one");
        responses[1] = greeter.greetMeAsync("two");
        responses[2] = greeter.greetMeAsync("three");
        this.verifyMissingResponse(responses);
        control.stopGreeter(SERVER_LOSS_CFG);
        LOG.fine("Stopped greeter server");
        this.out.getOutboundMessages().clear();
        this.in.getInboundMessages().clear();
        control.startGreeter(CFG);
        String nl = System.getProperty("line.separator");
        LOG.fine("Restarted greeter server" + nl + nl);
        this.verifyServerRecovery(responses);
        greeterBus.shutdown(true);
        control.stopGreeter(CFG);
        this.bus.shutdown(true);
    }

    void verifyMissingResponse(Response<GreetMeResponse>[] responses) throws Exception {
        this.awaitMessages(4, 6, 20000);
        Thread.sleep(1000L);
        int nDone = 0;
        for (int i = 0; i < responses.length; ++i) {
            if (!responses[i].isDone()) continue;
            ++nDone;
        }
        ServerPersistenceTest.assertEquals((String)"Unexpected number of responses already received.", (Object)2, (Object)nDone);
        MessageFlow mf = new MessageFlow(this.out.getOutboundMessages(), this.in.getInboundMessages());
        String[] expectedActions = new String[]{RMConstants.getCreateSequenceAction(), GREETME_ACTION, GREETME_ACTION, GREETME_ACTION};
        mf.verifyActions(expectedActions, true);
        mf.verifyPartialResponses(4);
        mf.purgePartialResponses();
        expectedActions = new String[]{RMConstants.getCreateSequenceResponseAction(), GREETME_RESPONSE_ACTION, GREETME_RESPONSE_ACTION};
        mf.verifyActions(expectedActions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyServerRecovery(Response<GreetMeResponse>[] responses) throws Exception {
        int nDone = 0;
        long waited = 0L;
        while (waited < 5000L) {
            for (int i = 0; i < responses.length; ++i) {
                if (!responses[i].isDone()) continue;
                ++nDone;
            }
            if (nDone == 3) break;
            Thread.sleep(500L);
            nDone = 0;
        }
        ServerPersistenceTest.assertEquals((String)"Not all responses have been received.", (Object)3, (Object)nDone);
        ServerPersistenceTest serverPersistenceTest = this;
        synchronized (serverPersistenceTest) {
            MessageFlow mf = new MessageFlow(this.out.getOutboundMessages(), this.in.getInboundMessages());
            int nOut = this.out.getOutboundMessages().size();
            int nIn = this.in.getInboundMessages().size();
            ServerPersistenceTest.assertEquals((String)"Unexpected outbound message(s)", (Object)0, (Object)nOut);
            ServerPersistenceTest.assertTrue((nIn >= 1 ? 1 : 0) != 0);
            String[] expectedActions = new String[nIn];
            for (int i = 0; i < nIn; ++i) {
                expectedActions[i] = GREETME_RESPONSE_ACTION;
            }
            mf.verifyActions(expectedActions, false);
        }
    }

    protected void awaitMessages(int nExpectedOut, int nExpectedIn) {
        this.awaitMessages(nExpectedOut, nExpectedIn, 10000);
    }

    private void awaitMessages(int nExpectedOut, int nExpectedIn, int timeout) {
        MessageRecorder mr = new MessageRecorder(this.out, this.in);
        mr.awaitMessages(nExpectedOut, nExpectedIn, timeout);
    }

    <T> Response<T>[] cast(Response[] val) {
        return val;
    }
}

