/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.security;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.security.GreeterImpl;
import org.apache.cxf.systest.ws.security.Server;
import org.apache.cxf.systest.ws.security.TestOutHandler;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.hello_world_soap_http.Greeter;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecurityClientTest
extends AbstractBusClientServerTestBase {
    private static final URL WSDL_LOC;
    private static final QName GREETER_SERVICE_QNAME;
    private static final QName TIMESTAMP_SIGN_ENCRYPT_PORT_QNAME;
    private static final QName USERNAME_TOKEN_PORT_QNAME;

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecurityClientTest.assertTrue((String)"Server failed to launch", (boolean)WSSecurityClientTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testTimestampSignEncrypt() {
        BusFactory.setDefaultBus((Bus)new SpringBusFactory().createBus("org/apache/cxf/systest/ws/security/client.xml"));
        Service svc = Service.create((URL)WSDL_LOC, (QName)GREETER_SERVICE_QNAME);
        Greeter greeter = (Greeter)svc.getPort(TIMESTAMP_SIGN_ENCRYPT_PORT_QNAME, Greeter.class);
        ArrayList<TestOutHandler> handlerChain = new ArrayList<TestOutHandler>();
        Binding binding = ((BindingProvider)greeter).getBinding();
        TestOutHandler handler = new TestOutHandler();
        handlerChain.add(handler);
        binding.setHandlerChain(handlerChain);
        greeter.sayHi();
        WSSecurityClientTest.assertTrue((String)"expected Handler.handleMessage() to be called", (boolean)handler.handleMessageCalledOutbound);
        WSSecurityClientTest.assertFalse((String)"expected Handler.handleFault() not to be called", (boolean)handler.handleFaultCalledOutbound);
    }

    @Test
    public void testMalformedSecurityHeaders() throws Exception {
        Dispatch<Source> dispatcher = null;
        InputStream is = null;
        String result = null;
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/UsernameTokenRequest.xml"))));
        WSSecurityClientTest.assertTrue((result.indexOf("Bonjour") != -1 ? 1 : 0) != 0);
        WSSecurityClientTest.assertNotNull((Object)GreeterImpl.getUser());
        WSSecurityClientTest.assertEquals((Object)"alice", (Object)GreeterImpl.getUser().getName());
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/NoHeadersRequest.xml");
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is)));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/EmptyHeaderRequest.xml");
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is)));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/EmptySecurityHeaderRequest.xml");
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is)));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
    }

    private static Dispatch<Source> createUsernameTokenDispatcher() {
        Service service = Service.create((QName)GREETER_SERVICE_QNAME);
        service.addPort(USERNAME_TOKEN_PORT_QNAME, "http://www.w3.org/2004/08/wsdl/http", "http://localhost:9000/GreeterService/UsernameTokenPort");
        Dispatch dispatcher = service.createDispatch(USERNAME_TOKEN_PORT_QNAME, Source.class, Service.Mode.MESSAGE);
        Map requestContext = dispatcher.getRequestContext();
        requestContext.put("javax.xml.ws.http.request.method", "POST");
        return dispatcher;
    }

    private static String source2String(Source source) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(bos);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        Properties oprops = new Properties();
        oprops.put("omit-xml-declaration", "yes");
        trans.setOutputProperties(oprops);
        trans.transform(source, sr);
        return bos.toString();
    }

    static {
        URL tmp = null;
        try {
            tmp = WSSecurityClientTest.class.getClassLoader().getResource("org/apache/cxf/systest/ws/security/hello_world.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WSDL_LOC = tmp;
        GREETER_SERVICE_QNAME = new QName("http://apache.org/hello_world_soap_http", "GreeterService");
        TIMESTAMP_SIGN_ENCRYPT_PORT_QNAME = new QName("http://apache.org/hello_world_soap_http", "TimestampSignEncryptPort");
        USERNAME_TOKEN_PORT_QNAME = new QName("http://apache.org/hello_world_soap_http", "UsernameTokenPort");
    }
}

