/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMessageRecorder
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(InMessageRecorder.class);
    private List<byte[]> inbound = new ArrayList<byte[]>();

    public InMessageRecorder() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is == null) {
            return;
        }
        LoadingByteArrayOutputStream bos = new LoadingByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            is.close();
            bos.close();
            this.inbound.add(bos.toByteArray());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("inbound: " + bos.toString());
            }
            ByteArrayInputStream bis = bos.createInputStream();
            message.setContent(InputStream.class, (Object)bis);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<byte[]> getInboundMessages() {
        return this.inbound;
    }
}

