/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.util;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.apache.cxf.ws.rm.RMConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFlow
extends Assert {
    private List<byte[]> inStreams;
    private List<byte[]> outStreams;
    private List<Document> outboundMessages;
    private List<Document> inboundMessages = new ArrayList<Document>();

    public MessageFlow(List<byte[]> out, List<byte[]> in) throws Exception {
        this.outboundMessages = new ArrayList<Document>();
        this.reset(out, in);
    }

    public void clear() throws Exception {
        this.inStreams.clear();
        this.outStreams.clear();
    }

    public final void reset(List<byte[]> out, List<byte[]> in) throws Exception {
        Document document;
        ByteArrayInputStream is;
        byte[] bytes;
        int i;
        int i2;
        for (i2 = 0; i2 < this.inboundMessages.size(); ++i2) {
            in.remove(0);
        }
        this.inStreams = in;
        for (i2 = 0; i2 < this.outboundMessages.size(); ++i2) {
            out.remove(0);
        }
        this.outStreams = out;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder parser = factory.newDocumentBuilder();
        this.inboundMessages.clear();
        for (i = 0; i < this.inStreams.size(); ++i) {
            bytes = this.inStreams.get(i);
            is = new ByteArrayInputStream(bytes);
            document = parser.parse(is);
            this.inboundMessages.add(document);
        }
        this.outboundMessages.clear();
        for (i = 0; i < this.outStreams.size(); ++i) {
            bytes = this.outStreams.get(i);
            is = new ByteArrayInputStream(bytes);
            document = parser.parse(is);
            this.outboundMessages.add(document);
        }
    }

    public void verifyActions(String[] expectedActions, boolean outbound) throws Exception {
        MessageFlow.assertEquals((int)expectedActions.length, (int)(outbound ? this.outboundMessages.size() : this.inboundMessages.size()));
        for (int i = 0; i < expectedActions.length; ++i) {
            String action;
            String string = action = outbound ? this.getAction(this.outboundMessages.get(i)) : this.getAction(this.inboundMessages.get(i));
            if (null == expectedActions[i]) {
                MessageFlow.assertNull((String)((outbound ? "Outbound " : "Inbound") + " message " + i + " has unexpected action: " + action), (Object)action);
                continue;
            }
            MessageFlow.assertEquals((String)((outbound ? "Outbound " : "Inbound") + " message " + i + " does not contain expected action header" + System.getProperty("line.separator")), (String)expectedActions[i], (String)action);
        }
    }

    public void verifyActionsIgnoringPartialResponses(String[] expectedActions) throws Exception {
        int j = 0;
        for (int i = 0; i < this.inboundMessages.size() && j < expectedActions.length; ++i) {
            String action = this.getAction(this.inboundMessages.get(i));
            if (null == action && this.emptyBody(this.inboundMessages.get(i))) continue;
            if (null == expectedActions[j]) {
                MessageFlow.assertNull((String)("Inbound message " + i + " has unexpected action: " + action), (Object)action);
            } else {
                MessageFlow.assertEquals((String)("Inbound message " + i + " has unexpected action: "), (String)expectedActions[j], (String)action);
            }
            ++j;
        }
        if (j < expectedActions.length) {
            MessageFlow.fail((String)"Inbound messages do not contain all expected actions.");
        }
    }

    public boolean checkActions(String[] expectedActions, boolean outbound) throws Exception {
        if (expectedActions.length != (outbound ? this.outboundMessages.size() : this.inboundMessages.size())) {
            return false;
        }
        for (int i = 0; i < expectedActions.length; ++i) {
            String action;
            String string = action = outbound ? this.getAction(this.outboundMessages.get(i)) : this.getAction(this.inboundMessages.get(i));
            if (!(null == expectedActions[i] ? action != null : !expectedActions[i].equals(action))) continue;
            return false;
        }
        return true;
    }

    public void verifyAction(String expectedAction, int expectedCount, boolean outbound, boolean exact) throws Exception {
        int messageCount = outbound ? this.outboundMessages.size() : this.inboundMessages.size();
        int count = 0;
        for (int i = 0; i < messageCount; ++i) {
            String action;
            String string = action = outbound ? this.getAction(this.outboundMessages.get(i)) : this.getAction(this.inboundMessages.get(i));
            if (null == expectedAction) {
                if (action != null) continue;
                ++count;
                continue;
            }
            if (!expectedAction.equals(action)) continue;
            ++count;
        }
        if (exact) {
            MessageFlow.assertEquals((String)("unexpected count for action: " + expectedAction), (int)expectedCount, (int)count);
        } else {
            MessageFlow.assertTrue((String)("unexpected count for action: " + expectedAction + ": " + count), (expectedCount <= count ? 1 : 0) != 0);
        }
    }

    public void verifyMessageNumbers(String[] expectedMessageNumbers, boolean outbound) throws Exception {
        this.verifyMessageNumbers(expectedMessageNumbers, outbound, true);
    }

    public void verifyMessageNumbers(String[] expectedMessageNumbers, boolean outbound, boolean exact) throws Exception {
        int actualMessageCount;
        int n = actualMessageCount = outbound ? this.outboundMessages.size() : this.inboundMessages.size();
        if (exact) {
            MessageFlow.assertEquals((int)expectedMessageNumbers.length, (int)actualMessageCount);
        } else {
            MessageFlow.assertTrue((expectedMessageNumbers.length <= actualMessageCount ? 1 : 0) != 0);
        }
        if (exact) {
            for (int i = 0; i < expectedMessageNumbers.length; ++i) {
                Element e;
                Element element = e = outbound ? this.getSequence(this.outboundMessages.get(i)) : this.getSequence(this.inboundMessages.get(i));
                if (null == expectedMessageNumbers[i]) {
                    MessageFlow.assertNull((String)((outbound ? "Outbound" : "Inbound") + " message " + i + " contains unexpected message number "), (Object)e);
                    continue;
                }
                MessageFlow.assertEquals((String)((outbound ? "Outbound" : "Inbound") + " message " + i + " does not contain expected message number " + expectedMessageNumbers[i]), (String)expectedMessageNumbers[i], (String)this.getMessageNumber(e));
            }
        } else {
            boolean[] matches = new boolean[expectedMessageNumbers.length];
            block1: for (int i = 0; i < actualMessageCount; ++i) {
                String messageNumber = null;
                Element e = outbound ? this.getSequence(this.outboundMessages.get(i)) : this.getSequence(this.inboundMessages.get(i));
                messageNumber = null == e ? null : this.getMessageNumber(e);
                for (int j = 0; j < expectedMessageNumbers.length; ++j) {
                    if (messageNumber == null) {
                        if (expectedMessageNumbers[j] != null || matches[j]) continue;
                        matches[j] = true;
                        continue block1;
                    }
                    if (!messageNumber.equals(expectedMessageNumbers[j]) || matches[j]) continue;
                    matches[j] = true;
                    continue block1;
                }
            }
            for (int k = 0; k < expectedMessageNumbers.length; ++k) {
                MessageFlow.assertTrue((String)("no match for message number: " + expectedMessageNumbers[k]), (boolean)matches[k]);
            }
        }
    }

    public void verifyLastMessage(boolean[] expectedLastMessages, boolean outbound) throws Exception {
        this.verifyLastMessage(expectedLastMessages, outbound, true);
    }

    public void verifyLastMessage(boolean[] expectedLastMessages, boolean outbound, boolean exact) throws Exception {
        int actualMessageCount;
        int n = actualMessageCount = outbound ? this.outboundMessages.size() : this.inboundMessages.size();
        if (exact) {
            MessageFlow.assertEquals((int)expectedLastMessages.length, (int)actualMessageCount);
        } else {
            MessageFlow.assertTrue((expectedLastMessages.length <= actualMessageCount ? 1 : 0) != 0);
        }
        for (int i = 0; i < expectedLastMessages.length; ++i) {
            Element e = outbound ? this.getSequence(this.outboundMessages.get(i)) : this.getSequence(this.inboundMessages.get(i));
            boolean lastMessage = null == e ? false : this.getLastMessage(e);
            MessageFlow.assertEquals((String)("Outbound message " + i + (expectedLastMessages[i] ? " does not contain expected last message element." : " contains last message element.")), (boolean)expectedLastMessages[i], (boolean)lastMessage);
        }
    }

    public void verifyAcknowledgements(boolean[] expectedAcks, boolean outbound) throws Exception {
        MessageFlow.assertEquals((int)expectedAcks.length, (int)(outbound ? this.outboundMessages.size() : this.inboundMessages.size()));
        for (int i = 0; i < expectedAcks.length; ++i) {
            boolean ack;
            boolean bl = outbound ? null != this.getAcknowledgment(this.outboundMessages.get(i)) : (ack = null != this.getAcknowledgment(this.inboundMessages.get(i)));
            if (expectedAcks[i]) {
                MessageFlow.assertTrue((String)((outbound ? "Outbound" : "Inbound") + " message " + i + " does not contain expected acknowledgement"), (boolean)ack);
                continue;
            }
            MessageFlow.assertFalse((String)((outbound ? "Outbound" : "Inbound") + " message " + i + " contains unexpected acknowledgement"), (boolean)ack);
        }
    }

    public void verifyAcknowledgements(int expectedAcks, boolean outbound, boolean exact) throws Exception {
        int actualMessageCount = outbound ? this.outboundMessages.size() : this.inboundMessages.size();
        int ackCount = 0;
        for (int i = 0; i < actualMessageCount; ++i) {
            boolean ack;
            boolean bl = outbound ? null != this.getAcknowledgment(this.outboundMessages.get(i)) : (ack = null != this.getAcknowledgment(this.inboundMessages.get(i)));
            if (!ack) continue;
            ++ackCount;
        }
        if (exact) {
            MessageFlow.assertEquals((String)"unexpected number of acks", (int)expectedAcks, (int)ackCount);
        } else {
            MessageFlow.assertTrue((String)("unexpected number of acks: " + ackCount), (expectedAcks <= ackCount ? 1 : 0) != 0);
        }
    }

    public void verifyAckRequestedOutbound(boolean outbound) throws Exception {
        boolean found = false;
        List<Document> messages = outbound ? this.outboundMessages : this.inboundMessages;
        for (Document d : messages) {
            Element se = this.getAckRequested(d);
            if (se == null) continue;
            found = true;
            break;
        }
        MessageFlow.assertTrue((String)"expected AckRequested", (boolean)found);
    }

    public void verifySequenceFault(QName code, boolean outbound, int index) throws Exception {
        Document d;
        Document document = d = outbound ? this.outboundMessages.get(index) : this.inboundMessages.get(index);
        assert (null != this.getRMHeaderElement(d, RMConstants.getSequenceFaultName()));
    }

    public void verifyHeader(QName name, boolean outbound, int index) throws Exception {
        Document d = outbound ? this.outboundMessages.get(index) : this.inboundMessages.get(index);
        MessageFlow.assertNotNull((String)((outbound ? "Outbound" : "Inbound") + " message " + index + " does not have " + name + "header."), (Object)this.getHeaderElement(d, name.getNamespaceURI(), name.getLocalPart()));
    }

    public void verifyNoHeader(QName name, boolean outbound, int index) throws Exception {
        Document d = outbound ? this.outboundMessages.get(index) : this.inboundMessages.get(index);
        MessageFlow.assertNull((String)((outbound ? "Outbound" : "Inbound") + " message " + index + " has " + name + "header."), (Object)this.getHeaderElement(d, name.getNamespaceURI(), name.getLocalPart()));
    }

    protected String getAction(Document document) throws Exception {
        Element e = this.getHeaderElement(document, RMConstants.getAddressingNamespace(), "Action");
        if (null != e) {
            return this.getText(e);
        }
        return null;
    }

    protected Element getSequence(Document document) throws Exception {
        return this.getRMHeaderElement(document, RMConstants.getSequenceName());
    }

    public String getMessageNumber(Element elem) throws Exception {
        for (Node nd = elem.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !"MessageNumber".equals(nd.getLocalName())) continue;
            return this.getText(nd);
        }
        return null;
    }

    private boolean getLastMessage(Element element) throws Exception {
        for (Node nd = element.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !"LastMessage".equals(nd.getLocalName())) continue;
            return true;
        }
        return false;
    }

    protected Element getAcknowledgment(Document document) throws Exception {
        return this.getRMHeaderElement(document, RMConstants.getSequenceAckName());
    }

    private Element getAckRequested(Document document) throws Exception {
        return this.getRMHeaderElement(document, RMConstants.getAckRequestedName());
    }

    private Element getRMHeaderElement(Document document, String name) throws Exception {
        return this.getHeaderElement(document, RMConstants.getNamespace(), name);
    }

    private Element getHeaderElement(Document document, String namespace, String localName) throws Exception {
        Node nd;
        Element envelopeElement = document.getDocumentElement();
        Node headerElement = null;
        for (nd = envelopeElement.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !"Header".equals(nd.getLocalName())) continue;
            headerElement = (Element)nd;
            break;
        }
        if (null == headerElement) {
            return null;
        }
        for (nd = headerElement.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType()) continue;
            Element element = (Element)nd;
            String ns = element.getNamespaceURI();
            String ln = element.getLocalName();
            if (!namespace.equals(ns) || !localName.equals(ln)) continue;
            return element;
        }
        return null;
    }

    public void verifyMessages(int nExpected, boolean outbound) {
        this.verifyMessages(nExpected, outbound, true);
    }

    public void verifyMessages(int nExpected, boolean outbound, boolean exact) {
        if (outbound) {
            if (exact) {
                MessageFlow.assertEquals((String)("Unexpected number of outbound messages" + this.outboundDump()), (int)nExpected, (int)this.outboundMessages.size());
            } else {
                MessageFlow.assertTrue((String)("Unexpected number of outbound messages: " + this.outboundDump()), (nExpected <= this.outboundMessages.size() ? 1 : 0) != 0);
            }
        } else if (exact) {
            MessageFlow.assertEquals((String)"Unexpected number of inbound messages", (int)nExpected, (int)this.inboundMessages.size());
        } else {
            MessageFlow.assertTrue((String)("Unexpected number of inbound messages: " + this.inboundMessages.size()), (nExpected <= this.inboundMessages.size() ? 1 : 0) != 0);
        }
    }

    public void purgePartialResponses() throws Exception {
        for (int i = this.inboundMessages.size() - 1; i >= 0; --i) {
            if (!this.isPartialResponse(this.inboundMessages.get(i))) continue;
            this.inboundMessages.remove(i);
        }
    }

    public void purge() {
        this.inboundMessages.clear();
        this.outboundMessages.clear();
        this.inStreams.clear();
        this.outStreams.clear();
    }

    public void verifyPartialResponses(int nExpected) throws Exception {
        this.verifyPartialResponses(nExpected, null);
    }

    public void verifyPartialResponses(int nExpected, boolean[] piggybackedAcks) throws Exception {
        int npr = 0;
        for (int i = 0; i < this.inboundMessages.size(); ++i) {
            if (!this.isPartialResponse(this.inboundMessages.get(i))) continue;
            if (piggybackedAcks != null) {
                Element ack = this.getAcknowledgment(this.inboundMessages.get(i));
                if (piggybackedAcks[npr]) {
                    MessageFlow.assertNotNull((String)("Partial response " + npr + " does not include acknowledgement."), (Object)ack);
                } else {
                    MessageFlow.assertNull((String)("Partial response " + npr + " has unexpected acknowledgement."), (Object)ack);
                }
            }
            ++npr;
        }
        MessageFlow.assertEquals((String)"Inbound messages did not contain expected number of partial responses.", (int)nExpected, (int)npr);
    }

    public boolean isPartialResponse(Document d) throws Exception {
        return null == this.getAction(d) && this.emptyBody(d);
    }

    public boolean emptyBody(Document d) throws Exception {
        Element envelopeElement = d.getDocumentElement();
        Node bodyElement = null;
        for (Node nd = envelopeElement.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (1 != nd.getNodeType() || !"Body".equals(nd.getLocalName())) continue;
            bodyElement = (Element)nd;
            break;
        }
        return null == bodyElement || !bodyElement.hasChildNodes();
    }

    private String outboundDump() {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(System.getProperty("line.separator"));
            for (int i = 0; i < this.outStreams.size(); ++i) {
                buf.append("[");
                buf.append(i);
                buf.append("] : ");
                buf.append(new String(this.outStreams.get(i)));
                buf.append(System.getProperty("line.separator"));
            }
        }
        catch (Exception ex) {
            return "";
        }
        return buf.toString();
    }

    private String getText(Node node) {
        for (Node nd = node.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
            if (3 != nd.getNodeType()) continue;
            return nd.getNodeValue();
        }
        return null;
    }

    protected QName getNodeName(Node nd) {
        return new QName(nd.getNamespaceURI(), nd.getLocalName());
    }
}

