/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.util;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.io.WriteOnCloseOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutMessageRecorder
extends AbstractPhaseInterceptor {
    private static final Logger LOG = LogUtils.getLogger(OutMessageRecorder.class);
    private List<byte[]> outbound = new ArrayList<byte[]>();

    public OutMessageRecorder() {
        super("pre-stream");
        this.addAfter(RetransmissionInterceptor.class.getName());
        this.addBefore(StaxOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (null == os) {
            return;
        }
        WriteOnCloseOutputStream stream = RMUtils.createCachedStream((Message)message, (OutputStream)os);
        stream.registerCallback((CachedOutputStreamCallback)new RecorderCallback());
    }

    public List<byte[]> getOutboundMessages() {
        return this.outbound;
    }

    class RecorderCallback
    implements CachedOutputStreamCallback {
        RecorderCallback() {
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            try {
                byte[] bytes = cos.getBytes();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("outbound: " + bytes);
                }
                OutMessageRecorder.this.outbound.add(bytes);
            }
            catch (Exception e) {
                LOG.fine("Can't record message from output stream class: " + cos.getOut().getClass().getName());
            }
        }
    }
}

