/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.util.logging.Logger;
import junit.framework.Assert;
import org.apache.cxf.common.logging.LogUtils;

public abstract class AbstractTestServerBase
extends Assert {
    boolean inProcess;

    protected abstract void run();

    protected Logger getLog() {
        return LogUtils.getLogger(((Object)((Object)this)).getClass());
    }

    public void startInProcess() throws Exception {
        this.inProcess = true;
        this.run();
        this.ready();
    }

    public boolean stopInProcess() throws Exception {
        boolean ret = true;
        if (this.verify(this.getLog())) {
            if (!this.inProcess) {
                System.out.println("server passed");
            }
        } else {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            System.out.println("running server");
            this.run();
            System.out.println("signal ready");
            this.ready();
            System.in.read();
            System.out.println("stopping bus");
            this.tearDown();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.startFailed();
        }
        finally {
            if (this.verify(this.getLog())) {
                System.out.println("server passed");
            } else {
                System.out.println("server startup failed (not a log message)");
            }
            System.out.println("server stopped");
            System.exit(0);
        }
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    protected void ready() {
        if (!this.inProcess) {
            System.out.println("server ready");
        }
    }

    protected void startFailed() {
        System.out.println("server startup failed (not a log message)");
        System.exit(-1);
    }

    protected boolean verify(Logger log) {
        return true;
    }
}

