/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtil {
    private TestUtil() {
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TestUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getClassPath(ClassLoader loader) throws URISyntaxException {
        StringBuffer classPath = new StringBuffer();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                String file = url.getFile();
                if (file.indexOf("junit") != -1) continue;
                classPath.append(url.toURI().getPort());
                classPath.append(System.getProperty("path.separator"));
            }
        }
        return classPath.toString();
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method[] declMethods;
        for (Method method : declMethods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }
}

