/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.junit.After;
import org.junit.AfterClass;

public abstract class AbstractBusClientServerTestBase
extends AbstractClientServerTestBase {
    protected static String defaultConfigFileName;
    protected static Bus staticBus;
    protected String configFileName = defaultConfigFileName;
    protected Bus bus;

    public void createBus(String config) throws Exception {
        this.configFileName = config;
        this.createBus();
    }

    public void createBus() throws Exception {
        if (this.configFileName != null) {
            System.setProperty("cxf.config.file", this.configFileName);
        }
        BusFactory bf = BusFactory.newInstance();
        this.bus = bf.createBus();
        BusFactory.setDefaultBus((Bus)this.bus);
    }

    public static Bus getStaticBus() {
        return staticBus;
    }

    public static Bus createStaticBus(String config) throws Exception {
        defaultConfigFileName = config;
        return AbstractBusClientServerTestBase.createStaticBus();
    }

    public static Bus createStaticBus() throws Exception {
        if (defaultConfigFileName != null) {
            System.setProperty("cxf.config.file", defaultConfigFileName);
        }
        BusFactory bf = BusFactory.newInstance();
        staticBus = bf.createBus();
        BusFactory.setDefaultBus((Bus)staticBus);
        return staticBus;
    }

    @After
    public void deleteBus() throws Exception {
        if (null != this.bus) {
            this.bus.shutdown(true);
            this.bus = null;
        }
        if (this.configFileName != null) {
            System.clearProperty("cxf.config.file");
        }
    }

    @AfterClass
    public static void deleteStaticBus() throws Exception {
        if (null != staticBus) {
            staticBus.shutdown(true);
            staticBus = null;
        }
        if (defaultConfigFileName != null) {
            System.clearProperty("cxf.config.file");
        }
    }

    protected Bus getBus() {
        if (this.bus == null) {
            return staticBus;
        }
        return this.bus;
    }

    protected void setBus(Bus b) {
        this.bus = b;
    }

    protected HttpURLConnection getHttpConnection(String target) throws Exception {
        URL url = new URL(target);
        URLConnection connection = url.openConnection();
        AbstractBusClientServerTestBase.assertTrue((boolean)(connection instanceof HttpURLConnection));
        return (HttpURLConnection)connection;
    }

    protected boolean runClient(Runnable clientImpl, long timeOut, TimeUnit timeUnit) throws InterruptedException {
        FutureTask<Object> client = new FutureTask<Object>(clientImpl, null);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        tpe.execute(client);
        tpe.shutdown();
        tpe.awaitTermination(timeOut, timeUnit);
        return client.isDone();
    }

    static {
        System.setProperty("javax.xml.ws.spi.Provider", "org.apache.cxf.jaxws.spi.ProviderImpl");
    }
}

