/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.recorders;

import java.util.List;
import junit.framework.Assert;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.testutil.recorders.InMessageRecorder;
import org.apache.cxf.testutil.recorders.OutMessageRecorder;

public class MessageRecorder
extends Assert {
    private OutMessageRecorder outRecorder;
    private InMessageRecorder inRecorder;

    public MessageRecorder(OutMessageRecorder or, InMessageRecorder ir) {
        this.inRecorder = ir;
        this.outRecorder = or;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitMessages(int nExpectedOut, int nExpectedIn, int timeout) {
        int nOut = 0;
        int nIn = 0;
        for (int waited = 0; waited <= timeout; waited += 100) {
            AbstractPhaseInterceptor abstractPhaseInterceptor = this.outRecorder;
            synchronized (abstractPhaseInterceptor) {
                nOut = this.outRecorder.getOutboundMessages().size();
            }
            abstractPhaseInterceptor = this.inRecorder;
            synchronized (abstractPhaseInterceptor) {
                nIn = this.inRecorder.getInboundMessages().size();
            }
            if (nIn >= nExpectedIn && nOut >= nExpectedOut) {
                return;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (nExpectedIn != nIn) {
            System.out.println((nExpectedIn < nIn ? "excess" : "shortfall") + " of " + Math.abs(nExpectedIn - nIn) + " incoming messages");
            System.out.println("\nMessages actually received:\n");
            List<byte[]> inbound = this.inRecorder.getInboundMessages();
            for (byte[] b : inbound) {
                System.out.println(new String(b) + "\n");
                System.out.println("----------------\n");
            }
        }
        if (nExpectedOut != nOut) {
            System.out.println((nExpectedOut < nOut ? "excess" : "shortfall") + " of " + Math.abs(nExpectedOut - nOut) + " outgoing messages");
            System.out.println("\nMessages actually sent:\n");
            List<byte[]> outbound = this.outRecorder.getOutboundMessages();
            for (byte[] b : outbound) {
                System.out.println(new String(b) + "\n");
                System.out.println("----------------\n");
            }
        }
        if (nExpectedIn > nIn) {
            MessageRecorder.assertEquals((String)"Did not receive expected number of inbound messages", (int)nExpectedIn, (int)nIn);
        }
        if (nExpectedOut > nOut) {
            MessageRecorder.assertEquals((String)"Did not send expected number of outbound messages", (int)nExpectedOut, (int)nOut);
        }
    }
}

