/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.customer.book;

import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import org.apache.cxf.customer.book.Book;
import org.apache.cxf.customer.book.BookNotFoundDetails;
import org.apache.cxf.customer.book.BookNotFoundFault;
import org.apache.cxf.customer.book.BookService;
import org.apache.cxf.customer.book.Books;
import org.apache.cxf.customer.book.GetAnotherBook;
import org.apache.cxf.customer.book.GetBook;

@WebService(endpointInterface="org.apache.cxf.customer.book.BookService")
public class BookServiceImpl
implements BookService {
    long currentId = 1L;
    Map<Long, Book> books = new HashMap<Long, Book>();

    public BookServiceImpl() {
        Book book = this.createBook();
        System.out.println("Enregistre Book de id " + book.getId());
        this.books.put(book.getId(), book);
    }

    @Override
    public Books getBooks() {
        for (Map.Entry<Long, Book> me : this.books.entrySet()) {
            System.out.println("getBooks -> " + me.getKey() + " : " + me.getValue());
        }
        Books b = new Books();
        b.setBooks(this.books.values().toArray(new Book[this.books.size()]));
        return b;
    }

    @Override
    public Book getBook(GetBook getBook) throws BookNotFoundFault {
        for (Map.Entry<Long, Book> me : this.books.entrySet()) {
            System.out.println("getBook -> " + me.getKey() + " : " + me.getValue().getName() + ", " + me.getValue().getId());
        }
        System.out.println("Book de id " + getBook.getId());
        Book b = this.books.get(getBook.getId());
        if (b == null) {
            BookNotFoundDetails details = new BookNotFoundDetails();
            details.setId(getBook.getId());
            throw new BookNotFoundFault(details);
        }
        return b;
    }

    @Override
    public Book getAnotherBook(GetAnotherBook getAnotherBook) throws BookNotFoundFault {
        for (Map.Entry<Long, Book> me : this.books.entrySet()) {
            System.out.println("getBook -> " + me.getKey() + " : " + me.getValue().getName() + ", " + me.getValue().getId());
        }
        System.out.println("Book de id " + getAnotherBook.getId());
        Book b = this.books.get(getAnotherBook.getId());
        if (b == null) {
            BookNotFoundDetails details = new BookNotFoundDetails();
            details.setId(getAnotherBook.getId());
            throw new BookNotFoundFault(details);
        }
        return b;
    }

    @Override
    public void updateBook(Book b) {
        this.books.put(b.getId(), b);
        for (Map.Entry<Long, Book> me : this.books.entrySet()) {
            System.out.println("updateBook -> " + me.getKey() + " : " + me.getValue());
        }
    }

    @Override
    public long addBook(Book b) {
        long id = ++this.currentId;
        System.out.println("addBook : " + b.getName());
        b.setId(id);
        this.books.put(id, b);
        for (Map.Entry<Long, Book> me : this.books.entrySet()) {
            System.out.println("addBook -> " + me.getKey() + " : " + me.getValue().getName() + ", " + me.getValue().getId());
        }
        return b.getId();
    }

    @Override
    public void deleteBook(long id) {
        this.books.remove(id);
        for (Map.Entry<Long, Book> me : this.books.entrySet()) {
            System.out.println("deleteBook -> " + me.getKey() + " : " + me.getValue());
        }
    }

    final Book createBook() {
        Book b = new Book();
        b.setName("CXF in Action");
        b.setId(123L);
        return b;
    }
}

