/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.greeter_control;

import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.greeter_control.AbstractGreeterImpl;
import org.apache.cxf.greeter_control.Control;
import org.apache.cxf.greeter_control.FaultThrowingInterceptor;
import org.apache.cxf.greeter_control.types.FaultLocation;
import org.apache.cxf.greeter_control.types.StartGreeterResponse;
import org.apache.cxf.greeter_control.types.StopGreeterResponse;
import org.apache.cxf.interceptor.Interceptor;

@WebService(serviceName="ControlService", portName="ControlPort", endpointInterface="org.apache.cxf.greeter_control.Control", targetNamespace="http://cxf.apache.org/greeter_control")
public class ControlImpl
implements Control {
    private static final Logger LOG = LogUtils.getLogger(ControlImpl.class);
    protected Object implementor;
    protected String address;
    protected Endpoint endpoint;
    protected Bus greeterBus;

    public void setImplementor(Object i) {
        this.implementor = i;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void setAddress(String a) {
        this.address = a;
    }

    public String getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startGreeter(String cfgResource) {
        LOG.fine("Starting greeter with cfgResource: " + cfgResource);
        this.greeterBus = null;
        BusFactory.setDefaultBus(null);
        String original = System.clearProperty("cxf.config.file");
        try {
            if (cfgResource != null && cfgResource.length() > 0) {
                System.setProperty("cxf.config.file", cfgResource);
            }
            String a = this.address == null ? "http://localhost:9020/SoapContext/GreeterPort" : this.address;
            Object i = this.implementor == null ? new GreeterImpl() : this.implementor;
            this.endpoint = Endpoint.publish((String)a, (Object)i);
            LOG.info("Published greeter endpoint on bus with cfg file resource: " + cfgResource);
            this.greeterBus = BusFactory.getDefaultBus();
        }
        finally {
            System.clearProperty("cxf.config.file");
            if (null != original) {
                System.setProperty("cxf.config.file", cfgResource);
            }
        }
        if (this.implementor instanceof AbstractGreeterImpl) {
            ((AbstractGreeterImpl)this.implementor).resetLastOnewayArg();
        }
        return null != this.greeterBus;
    }

    @Override
    public boolean stopGreeter(String requestType) {
        LOG.fine("Stopping greeter");
        if (null != this.endpoint) {
            LOG.info("Stopping Greeter endpoint");
            this.endpoint.stop();
        } else {
            LOG.info("No endpoint active.");
        }
        this.endpoint = null;
        if (null != this.greeterBus) {
            this.greeterBus.shutdown(true);
        }
        this.greeterBus = null;
        return true;
    }

    @Override
    public void setFaultLocation(FaultLocation fl) {
        List interceptors = this.greeterBus.getInInterceptors();
        FaultThrowingInterceptor fi = null;
        for (Interceptor i : interceptors) {
            if (!(i instanceof FaultThrowingInterceptor)) continue;
            interceptors.remove(i);
            LOG.fine("Removed existing FaultThrowingInterceptor");
            break;
        }
        if (null == fl.getPhase() || "".equals(fl.getPhase())) {
            LOG.fine("Removed FaultThrowingInterceptor");
            return;
        }
        fi = new FaultThrowingInterceptor(fl.getPhase());
        if (null != fl.getBefore() && !"".equals(fl.getBefore())) {
            fi.addBefore(fl.getBefore());
        }
        if (null != fl.getAfter() && !"".equals(fl.getAfter())) {
            fi.addAfter(fl.getAfter());
        }
        interceptors.add(fi);
        LOG.fine("Added FaultThrowingInterceptor to phase " + fl.getPhase());
    }

    @Override
    public Future<?> startGreeterAsync(String requestType, AsyncHandler<StartGreeterResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<StartGreeterResponse> startGreeterAsync(String requestType) {
        return null;
    }

    @Override
    public Response<StopGreeterResponse> stopGreeterAsync(String requestType) {
        return null;
    }

    @Override
    public Future<?> stopGreeterAsync(String requestType, AsyncHandler<StopGreeterResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<?> setFaultLocationAsync(FaultLocation in) {
        return null;
    }

    @Override
    public Future<?> setFaultLocationAsync(FaultLocation in, AsyncHandler<?> asyncHandler) {
        return null;
    }

    @Override
    public Response<?> setRobustInOnlyModeAsync(boolean in) {
        return null;
    }

    @Override
    public Future<?> setRobustInOnlyModeAsync(boolean in, AsyncHandler<?> asyncHandler) {
        return null;
    }

    @Override
    public void setRobustInOnlyMode(boolean in) {
        this.endpoint.getProperties().put("org.apache.cxf.oneway.robust", in);
    }

    @WebService(serviceName="GreeterService", portName="GreeterPort", endpointInterface="org.apache.cxf.greeter_control.Greeter", targetNamespace="http://cxf.apache.org/greeter_control")
    class GreeterImpl
    extends AbstractGreeterImpl {
        GreeterImpl() {
        }
    }
}

