/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.extensions.jms;

import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.tools.common.extensions.jms.JMSAddress;
import org.apache.cxf.tools.common.extensions.jms.JMSAddressParser;
import org.w3c.dom.Element;

public class JMSAddressSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        JMSAddress jmsAddress = (JMSAddress)extension;
        StringBuffer sb = new StringBuffer(300);
        sb.append(" <" + XMLUtils.writeQName((Definition)def, (QName)elementType) + " ");
        sb.append(jmsAddress.getAttrXMLString());
        sb.append("/>");
        pw.print(sb.toString());
        pw.println();
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        JMSAddress jmsAddress = (JMSAddress)extReg.createExtension(parentType, elementType);
        jmsAddress.setElementType(elementType);
        jmsAddress.setElement(el);
        jmsAddress.setDocumentBaseURI(def.getDocumentBaseURI());
        JMSAddressParser parser = new JMSAddressParser();
        parser.parseElement(jmsAddress, el);
        if (jmsAddress.getAddress() == null || jmsAddress.getAddress().trim().length() == 0) {
            if (def.getNamespaces() != null) {
                jmsAddress.setAddress((String)def.getNamespaces().get("jms"));
            } else {
                jmsAddress.setAddress("http://cxf.apache.org/transports/jms");
            }
        }
        return jmsAddress;
    }
}

