/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.toolspec.parser;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.toolspec.Tool;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.common.toolspec.parser.Form;
import org.apache.cxf.tools.common.toolspec.parser.TokenInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommandLineParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CommandLineParser.class);
    private ToolSpec toolspec;

    public CommandLineParser(ToolSpec ts) {
        this.toolspec = ts;
    }

    public void setToolSpec(ToolSpec ts) {
        this.toolspec = ts;
    }

    public static String[] getArgsFromString(String s) {
        StringTokenizer toker = new StringTokenizer(s);
        ArrayList<String> res = new ArrayList<String>();
        while (toker.hasMoreTokens()) {
            res.add(toker.nextToken());
        }
        return res.toArray(new String[res.size()]);
    }

    public CommandDocument parseArguments(String args) throws BadUsageException {
        return this.parseArguments(CommandLineParser.getArgsFromString(args));
    }

    public CommandDocument parseArguments(String[] args) throws BadUsageException {
        ErrorVisitor errors;
        if (LOG.isLoggable(Level.FINE)) {
            StringBuffer debugMsg = new StringBuffer("Parsing arguments: ");
            for (int i = 0; i < args.length; ++i) {
                debugMsg.append(args[i]).append(" ");
            }
            LOG.fine(debugMsg.toString());
        }
        if (this.toolspec == null) {
            throw new IllegalStateException("No schema known- call to acceptSchema() must be made and must succeed");
        }
        Document resultDoc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            resultDoc = factory.newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "FAIL_CREATE_DOM_MSG");
        }
        Element commandEl = resultDoc.createElementNS("http://cxf.apache.org/Xutil/Command", "command");
        commandEl.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://cxf.apache.org/Xutil/Command http://cxf.apache.org/schema/xutil/command.xsd");
        commandEl.setAttribute("xmlns", "http://cxf.apache.org/Xutil/Command");
        commandEl.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        resultDoc.appendChild(commandEl);
        TokenInputStream tokens = new TokenInputStream(args);
        Element usage = this.toolspec.getUsage();
        NodeList usageForms = this.toolspec.getUsageForms();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Found " + usageForms.getLength() + " alternative forms of usage, will use default form");
        }
        if (usageForms.getLength() > 0) {
            errors = new ErrorVisitor();
            for (int i = 0; i < usageForms.getLength(); ++i) {
                Form form = new Form((Element)usageForms.item(i));
                int pos = tokens.getPosition();
                if (form.accept(tokens, commandEl, errors)) {
                    commandEl.setAttribute("form", form.getName());
                    break;
                }
                tokens.setPosition(pos);
                if (i != usageForms.getLength() - 1) continue;
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.info("No more forms left to try, returning null");
                }
                this.throwUsage(errors);
            }
        } else {
            Form form = new Form(usage);
            errors = new ErrorVisitor();
            if (!form.accept(tokens, commandEl, errors)) {
                this.throwUsage(errors);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            try {
                Transformer serializer = TransformerFactory.newInstance().newTransformer(new StreamSource(Tool.class.getResourceAsStream("indent-no-xml-declaration.xsl")));
                serializer.transform(new DOMSource(resultDoc), new StreamResult(new PrintStream(System.out)));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "ERROR_SERIALIZE_COMMAND_MSG", ex);
            }
        }
        return new CommandDocument(this.toolspec, resultDoc);
    }

    public void throwUsage(ErrorVisitor errors) throws BadUsageException {
        try {
            throw new BadUsageException(this.getUsage(), errors);
        }
        catch (TransformerException ex) {
            LOG.log(Level.SEVERE, "CANNOT_GET_USAGE_MSG", ex);
            throw new BadUsageException(errors);
        }
    }

    public String getUsage() throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream in = this.getClass().getResourceAsStream("usage.xsl");
        this.toolspec.transform(in, baos);
        return baos.toString();
    }

    public String getDetailedUsage() throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.toolspec.transform(this.getClass().getResourceAsStream("detailedUsage.xsl"), baos);
        return baos.toString();
    }

    public String getDetailedUsage(String id) {
        String result = null;
        Element element = this.toolspec.getElementById(id);
        NodeList annotations = element.getElementsByTagNameNS("http://cxf.apache.org/Xutil/ToolSpecification", "annotation");
        if (annotations != null && annotations.getLength() > 0) {
            result = annotations.item(0).getFirstChild().getNodeValue();
        }
        return result;
    }

    public String getToolUsage() {
        return this.toolspec.getAnnotation();
    }
}

