/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.JavaCodeBlock;
import org.apache.cxf.tools.common.model.JavaExpression;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaReturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClass
extends JavaInterface {
    private final List<JavaField> jfield = new ArrayList<JavaField>();

    public JavaClass() {
    }

    public JavaClass(JavaModel model) {
        super(model);
    }

    public void addField(JavaField f) {
        this.jfield.add(f);
    }

    public List<JavaField> getFields() {
        return this.jfield;
    }

    public JavaMethod appendGetter(JavaField field) {
        String getterName = "get" + StringUtils.capitalize((String)field.getParaName());
        JavaMethod jMethod = new JavaMethod(this);
        jMethod.setName(getterName);
        jMethod.setReturn(new JavaReturn(field.getParaName(), field.getType(), field.getTargetNamespace()));
        JavaCodeBlock block = new JavaCodeBlock();
        JavaExpression exp = new JavaExpression();
        exp.setValue("return this." + field.getParaName());
        block.getExpressions().add(exp);
        jMethod.setJavaCodeBlock(block);
        this.addMethod(jMethod);
        return jMethod;
    }

    public JavaMethod appendSetter(JavaField field) {
        String setterName = "set" + StringUtils.capitalize((String)field.getParaName());
        JavaMethod jMethod = new JavaMethod(this);
        jMethod.setReturn(new JavaReturn("return", "void", null));
        String paramName = this.getSetterParamName(field.getParaName());
        jMethod.addParameter(new JavaParameter(paramName, field.getType(), field.getTargetNamespace()));
        JavaCodeBlock block = new JavaCodeBlock();
        JavaExpression exp = new JavaExpression();
        exp.setValue("this." + field.getParaName() + " = " + paramName);
        block.getExpressions().add(exp);
        jMethod.setJavaCodeBlock(block);
        jMethod.setName(setterName);
        this.addMethod(jMethod);
        return jMethod;
    }

    private String getSetterParamName(String fieldName) {
        return "new" + StringUtils.capitalize((String)fieldName);
    }
}

