/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc;

import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.CommandInterfaceUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.CommandDocument;
import org.apache.cxf.tools.common.toolspec.parser.CommandLineError;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.misc.processor.WSDLToSoapProcessor;

public class WSDLToSoap
extends AbstractCXFToolContainer {
    static final String TOOL_NAME = "wsdl2soap";
    static final String BINDING_NAME_POSTFIX = "_Binding";
    static final String STYLE_DEF_VALUE = "document";
    static final String USE_DEF_VALUE = "literal";

    public WSDLToSoap(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    private Set<String> getArrayKeys() {
        return new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean exitOnFinish) {
        WSDLToSoapProcessor processor = new WSDLToSoapProcessor();
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                ToolContext env = new ToolContext();
                env.setParameters(this.getParametersMap(this.getArrayKeys()));
                if (this.isVerboseOn()) {
                    env.put("verbose", (Object)Boolean.TRUE);
                }
                env.put("args", (Object)this.getArgument());
                this.validate(env);
                this.setEnvParamDefValues(env);
                processor.setEnvironment(env);
                processor.process();
            }
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            this.err.println();
            this.err.println("WSDLToSoap Error : " + ex.getMessage());
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
        }
        catch (Exception ex) {
            this.err.println();
            this.err.println("WSDLToSoap Error : " + ex.getMessage());
            if (this.isVerboseOn()) {
                ex.printStackTrace(this.err);
            }
        }
        finally {
            this.tearDown();
        }
    }

    private void setEnvParamDefValues(ToolContext env) {
        if (!env.optionSet("binding")) {
            env.put("binding", (Object)(env.get("porttype") + BINDING_NAME_POSTFIX));
        }
        if (!env.optionSet("style")) {
            env.put("style", (Object)STYLE_DEF_VALUE);
        }
        if (!env.optionSet("use")) {
            env.put("use", (Object)USE_DEF_VALUE);
        }
    }

    private void validate(ToolContext env) throws ToolException {
        String outdir = (String)env.get("outputdir");
        if (outdir != null) {
            File dir = new File(outdir);
            if (!dir.exists() && !dir.mkdirs()) {
                Message msg = new Message("DIRECTORY_COULD_NOT_BE_CREATED", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
            if (!dir.isDirectory()) {
                Message msg = new Message("NOT_A_DIRECTORY", LOG, new Object[]{outdir});
                throw new ToolException(msg);
            }
        }
    }

    public static void main(String[] pargs) {
        CommandInterfaceUtils.commandCommonMain();
        try {
            ToolRunner.runTool(WSDLToSoap.class, (InputStream)WSDLToSoap.class.getResourceAsStream("wsdl2soap.xml"), (boolean)false, (String[])pargs);
        }
        catch (ToolException ex) {
            System.err.println("WSDL2Soap Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
        catch (Exception ex) {
            System.err.println("WSDL2Soap Error : " + ex.getMessage());
            System.err.println();
            ex.printStackTrace();
        }
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        CommandDocument doc = super.getCommandDocument();
        if (!doc.hasParameter("wsdlurl")) {
            errors.add((CommandLineError)new ErrorVisitor.UserError("WSDL/SCHEMA URL has to be specified"));
        }
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

