/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.api.ClassNameAllocator;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.Property;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import com.sun.tools.xjc.api.XJC;
import com.sun.tools.xjc.api.impl.s2j.SchemaCompilerImpl;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.DefaultValueWriter;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.JAXBUtils;
import org.apache.cxf.tools.wsdlto.core.DataBindingProfile;
import org.apache.cxf.tools.wsdlto.core.DefaultValueProvider;
import org.apache.cxf.tools.wsdlto.core.RandomValueProvider;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.ClassNameAllocatorImpl;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.JAXBBindErrorListener;
import org.apache.cxf.tools.wsdlto.databinding.jaxb.TypesCodeWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBDataBinding
implements DataBindingProfile {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBDataBinding.class);
    private static final Set<String> DEFAULT_TYPE_MAP = new HashSet<String>();
    private static final Map<String, String> JLDEFAULT_TYPE_MAP = new HashMap<String, String>();
    private S2JJAXBModel rawJaxbModelGenCode;
    private ToolContext context;
    private DefaultValueProvider defaultValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ToolContext c) throws ToolException {
        this.context = c;
        SchemaCompilerImpl schemaCompiler = (SchemaCompilerImpl)XJC.createSchemaCompiler();
        ClassCollector classCollector = (ClassCollector)this.context.get(ClassCollector.class);
        ClassNameAllocatorImpl allocator = new ClassNameAllocatorImpl(classCollector, c.optionSet("autoNameResolution"));
        schemaCompiler.setClassNameAllocator((ClassNameAllocator)allocator);
        JAXBBindErrorListener listener = new JAXBBindErrorListener(this.context.isVerbose());
        schemaCompiler.setErrorListener((ErrorListener)listener);
        List jaxbBindings = this.context.getJaxbBindingFile();
        Map schemaLists = (Map)this.context.get("schemaMap");
        Set keys = schemaLists.keySet();
        for (String key : keys) {
            Element ele = (Element)schemaLists.get(key);
            String tns = (ele = this.removeImportElement(ele)).getAttribute("targetNamespace");
            if (StringUtils.isEmpty((String)tns)) continue;
            if (this.context.get("validate") != null) {
                this.validateSchema(ele);
            }
            schemaCompiler.parseSchema(key, ele);
        }
        for (InputSource binding : jaxbBindings) {
            schemaCompiler.parseSchema(binding);
        }
        Map nsPkgMap = this.context.getNamespacePackageMap();
        for (String ns : nsPkgMap.keySet()) {
            File file = JAXBUtils.getPackageMappingSchemaBindingFile((String)ns, (String)this.context.mapPackageName(ns));
            try {
                InputSource ins = new InputSource(file.toURI().toString());
                schemaCompiler.parseSchema(ins);
            }
            finally {
                FileUtils.delete((File)file);
            }
        }
        if (this.context.getPackageName() != null) {
            schemaCompiler.setDefaultPackageName(this.context.getPackageName());
        }
        if (this.context.get("xjc") != null) {
            String xjcArgs = (String)this.context.get("xjc");
            Vector<String> args = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(xjcArgs, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String arg = tokenizer.nextToken();
                args.add(arg);
                LOG.log(Level.FINE, "xjc arg:" + arg);
            }
            Options opts = null;
            try {
                opts = this.getOptions(schemaCompiler);
                opts.addGrammar(new InputSource("null"));
                opts.parseArguments(args.toArray(new String[0]));
            }
            catch (BadCommandLineException e) {
                String msg = "XJC reported 'BadCommandLineException' for -xjc argument:" + xjcArgs;
                LOG.log(Level.FINE, msg, e);
                if (opts != null) {
                    String pluginUsage = this.getPluginUsageString(opts);
                    msg = "-X".equals(xjcArgs) ? pluginUsage : msg + pluginUsage;
                }
                throw new ToolException(msg, (Throwable)e);
            }
        }
        this.rawJaxbModelGenCode = schemaCompiler.bind();
        this.addedEnumClassToCollector(schemaLists, allocator);
        if (this.context.get("defaultValues") != null) {
            String cname = (String)this.context.get("defaultValues");
            if (StringUtils.isEmpty((String)cname)) {
                this.defaultValues = new RandomValueProvider();
            } else {
                if (cname.charAt(0) == '=') {
                    cname = cname.substring(1);
                }
                try {
                    this.defaultValues = (DefaultValueProvider)Class.forName(cname).newInstance();
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, e.getMessage());
                    throw new ToolException((Throwable)e);
                }
            }
        }
    }

    private String getPluginUsageString(Options opts) {
        StringBuffer buf = new StringBuffer();
        buf.append("\navaliable plugin options:\n");
        for (Plugin pl : opts.getAllPlugins()) {
            buf.append(pl.getUsage());
            buf.append('\n');
        }
        return buf.toString();
    }

    private Options getOptions(SchemaCompilerImpl schemaCompiler) throws ToolException {
        try {
            Field delegateField = schemaCompiler.getClass().getDeclaredField("opts");
            delegateField.setAccessible(true);
            return (Options)delegateField.get(schemaCompiler);
        }
        catch (Exception e) {
            String msg = "Failed to access 'opts' field of XJC SchemaCompilerImpl, reason:" + e;
            LOG.log(Level.SEVERE, msg, e);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    private void addedEnumClassToCollector(Map<String, Element> schemaList, ClassNameAllocatorImpl allocator) {
        for (Element schemaElement : schemaList.values()) {
            String packageName;
            String targetNamespace = schemaElement.getAttribute("targetNamespace");
            if (StringUtils.isEmpty((String)targetNamespace) || this.addedToClassCollector(packageName = this.context.mapPackageName(targetNamespace))) continue;
            allocator.assignClassName(packageName, "*");
        }
    }

    private boolean addedToClassCollector(String packageName) {
        ClassCollector classCollector = (ClassCollector)this.context.get(ClassCollector.class);
        List files = classCollector.getGeneratedFileInfo();
        for (String file : files) {
            int dotIndex;
            String sub = file.substring(0, (dotIndex = file.lastIndexOf(".")) - 1);
            if (!sub.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isSuppressCodeGen() {
        return this.context.optionSet("suppress");
    }

    public void generate(ToolContext c) throws ToolException {
        this.initialize(c);
        if (this.rawJaxbModelGenCode == null) {
            return;
        }
        try {
            String dir = (String)this.context.get("outputdir");
            TypesCodeWriter fileCodeWriter = new TypesCodeWriter(new File(dir), this.context.getExcludePkgList());
            if (this.rawJaxbModelGenCode instanceof S2JJAXBModel) {
                S2JJAXBModel schem2JavaJaxbModel = this.rawJaxbModelGenCode;
                JCodeModel jcodeModel = schem2JavaJaxbModel.generateCode(null, null);
                if (!this.isSuppressCodeGen()) {
                    jcodeModel.build((CodeWriter)fileCodeWriter);
                }
                this.context.put(JCodeModel.class, (Object)jcodeModel);
                for (String str : fileCodeWriter.getExcludeFileList()) {
                    this.context.getExcludeFileList().add(str);
                }
            }
            return;
        }
        catch (IOException e) {
            Message msg = new Message("FAIL_TO_GENERATE_TYPES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    public String getType(QName qname, boolean element) {
        Mapping mapping;
        TypeAndAnnotation typeAnno = this.rawJaxbModelGenCode.getJavaType(qname);
        if (element && (mapping = this.rawJaxbModelGenCode.get(qname)) != null) {
            typeAnno = mapping.getType();
        }
        if (typeAnno != null && typeAnno.getTypeClass() != null) {
            return typeAnno.getTypeClass().fullName();
        }
        return null;
    }

    public String getWrappedElementType(QName wrapperElement, QName item) {
        List propList;
        Mapping mapping = this.rawJaxbModelGenCode.get(wrapperElement);
        if (mapping != null && (propList = mapping.getWrapperStyleDrilldown()) != null) {
            for (Property pro : propList) {
                if (!pro.elementName().getNamespaceURI().equals(item.getNamespaceURI()) || !pro.elementName().getLocalPart().equals(item.getLocalPart())) continue;
                return pro.type().fullName();
            }
        }
        return null;
    }

    private Element removeImportElement(Element element) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        if (nodeList.getLength() == 0) {
            return element;
        }
        element = (Element)this.cloneNode(element.getOwnerDocument(), element, true);
        nodeList = element.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        ArrayList<Node> ns = new ArrayList<Node>();
        for (int tmp = 0; tmp < nodeList.getLength(); ++tmp) {
            Node importNode = nodeList.item(tmp);
            ns.add(importNode);
        }
        for (Node item : ns) {
            Node schemaNode = item.getParentNode();
            schemaNode.removeChild(item);
        }
        return element;
    }

    public Node cloneNode(Document document, Node node, boolean deep) throws DOMException {
        Node clone;
        if (document == null || node == null) {
            return null;
        }
        short type = node.getNodeType();
        if (node.getOwnerDocument() == document) {
            return node.cloneNode(deep);
        }
        switch (type) {
            case 4: {
                clone = document.createCDATASection(node.getNodeValue());
                break;
            }
            case 8: {
                clone = document.createComment(node.getNodeValue());
                break;
            }
            case 5: {
                clone = document.createEntityReference(node.getNodeName());
                break;
            }
            case 1: {
                clone = document.createElement(node.getNodeName());
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    ((Element)clone).setAttribute(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
                }
                break;
            }
            case 3: {
                clone = document.createTextNode(node.getNodeValue());
                break;
            }
            default: {
                return null;
            }
        }
        if (deep && type == 1) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                clone.appendChild(this.cloneNode(document, child, true));
            }
        }
        return clone;
    }

    public void validateSchema(Element ele) throws ToolException {
        block2: {
            SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            DOMSource domSrc = new DOMSource(ele);
            try {
                schemaFact.newSchema(domSrc);
            }
            catch (SAXException e) {
                if (e.getLocalizedMessage().indexOf("src-resolve.4.2") > -1) break block2;
                throw new ToolException("Schema Error : " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public DefaultValueWriter createDefaultValueWriter(QName qname, boolean element) {
        Mapping mapping;
        if (this.defaultValues == null) {
            return null;
        }
        TypeAndAnnotation typeAnno = this.rawJaxbModelGenCode.getJavaType(qname);
        if (element && (mapping = this.rawJaxbModelGenCode.get(qname)) != null) {
            typeAnno = mapping.getType();
        }
        if (typeAnno != null) {
            JType type = typeAnno.getTypeClass();
            return new JAXBDefaultValueWriter(type);
        }
        return null;
    }

    public DefaultValueWriter createDefaultValueWriterForWrappedElement(QName wrapperElement, QName item) {
        Mapping mapping;
        if (this.defaultValues != null && (mapping = this.rawJaxbModelGenCode.get(wrapperElement)) != null) {
            List propList = mapping.getWrapperStyleDrilldown();
            for (Property pro : propList) {
                if (!pro.elementName().getNamespaceURI().equals(item.getNamespaceURI()) || !pro.elementName().getLocalPart().equals(item.getLocalPart())) continue;
                return new JAXBDefaultValueWriter(pro.type());
            }
        }
        return null;
    }

    static {
        DEFAULT_TYPE_MAP.add("boolean");
        DEFAULT_TYPE_MAP.add("int");
        DEFAULT_TYPE_MAP.add("long");
        DEFAULT_TYPE_MAP.add("short");
        DEFAULT_TYPE_MAP.add("byte");
        DEFAULT_TYPE_MAP.add("float");
        DEFAULT_TYPE_MAP.add("double");
        DEFAULT_TYPE_MAP.add("char");
        DEFAULT_TYPE_MAP.add("java.lang.String");
        DEFAULT_TYPE_MAP.add("javax.xml.namespace.QName");
        DEFAULT_TYPE_MAP.add("java.net.URI");
        DEFAULT_TYPE_MAP.add("java.math.BigInteger");
        DEFAULT_TYPE_MAP.add("java.math.BigDecimal");
        DEFAULT_TYPE_MAP.add("javax.xml.datatype.XMLGregorianCalendar");
        DEFAULT_TYPE_MAP.add("javax.xml.datatype.Duration");
        JLDEFAULT_TYPE_MAP.put("java.lang.Character", "char");
        JLDEFAULT_TYPE_MAP.put("java.lang.Boolean", "boolean");
        JLDEFAULT_TYPE_MAP.put("java.lang.Integer", "int");
        JLDEFAULT_TYPE_MAP.put("java.lang.Long", "long");
        JLDEFAULT_TYPE_MAP.put("java.lang.Short", "short");
        JLDEFAULT_TYPE_MAP.put("java.lang.Byte", "byte");
        JLDEFAULT_TYPE_MAP.put("java.lang.Float", "float");
        JLDEFAULT_TYPE_MAP.put("java.lang.Double", "double");
        DEFAULT_TYPE_MAP.addAll(JLDEFAULT_TYPE_MAP.keySet());
    }

    private class JAXBDefaultValueWriter
    implements DefaultValueWriter {
        final JType type;

        JAXBDefaultValueWriter(JType tp) {
            this.type = tp;
        }

        public void writeDefaultValue(Writer writer, String indent, String path, String varName) throws IOException {
            path = path + "/" + varName;
            this.writeDefaultValue(writer, indent, path, varName, this.type);
        }

        public void writeDefaultValue(Writer writer, String indent, String path, String varName, JType tp) throws IOException {
            writer.write(tp.fullName());
            writer.write(" ");
            writer.write(varName);
            writer.write(" = ");
            if (tp.isArray()) {
                writer.write("new ");
                writer.write(tp.fullName());
                writer.write(" {};");
            } else if (DEFAULT_TYPE_MAP.contains(tp.fullName())) {
                this.writeDefaultType(writer, tp, path);
                writer.write(";");
            } else if (tp instanceof JDefinedClass) {
                JDefinedClass jdc = (JDefinedClass)tp;
                if (jdc.getClassType() == ClassType.ENUM) {
                    try {
                        Field f = jdc.getClass().getDeclaredField("enumConstantsByName");
                        f.setAccessible(true);
                        Map map = (Map)f.get(jdc);
                        Set values = CastUtils.cast(map.keySet());
                        String first = JAXBDataBinding.this.defaultValues.chooseEnumValue(path, values);
                        writer.write(tp.fullName());
                        writer.write(".");
                        writer.write(first);
                        writer.write(";");
                    }
                    catch (Exception e) {
                        IOException ex = new IOException(e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                } else {
                    writer.write("new ");
                    writer.write(tp.fullName());
                    writer.write("();");
                    this.fillInFields(writer, indent, path, varName, jdc);
                }
            } else {
                boolean found = false;
                JType tp2 = tp.erasure();
                try {
                    Field f = tp2.getClass().getDeclaredField("_class");
                    f.setAccessible(true);
                    Class cls = (Class)f.get(tp2);
                    if (List.class.isAssignableFrom(cls)) {
                        found = true;
                        writer.write("new ");
                        writer.write(tp.fullName().replace("java.util.List", "java.util.ArrayList"));
                        writer.write("();");
                        f = tp.getClass().getDeclaredField("args");
                        f.setAccessible(true);
                        List lcl = CastUtils.cast((List)((List)f.get(tp)));
                        JClass cl = (JClass)lcl.get(0);
                        int cnt = JAXBDataBinding.this.defaultValues.getListLength(path + "/" + varName);
                        for (int x = 0; x < cnt; ++x) {
                            writer.write("\n");
                            writer.write(indent);
                            this.writeDefaultValue(writer, indent, path + "/" + varName + "Val", varName + "Val" + cnt, (JType)cl);
                            writer.write("\n");
                            writer.write(indent);
                            writer.write(varName);
                            writer.write(".add(");
                            writer.write(varName + "Val" + cnt);
                            writer.write(");");
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!found) {
                    writer.write("null;");
                }
            }
        }

        public void fillInFields(Writer writer, String indent, String path, String varName, JDefinedClass tp) throws IOException {
            JClass sp = tp._extends();
            if (sp instanceof JDefinedClass) {
                this.fillInFields(writer, indent, path, varName, (JDefinedClass)sp);
            }
            Collection methods = tp.methods();
            for (JMethod m : methods) {
                if (m.name().startsWith("set")) {
                    writer.write("\n");
                    writer.write(indent);
                    if (DEFAULT_TYPE_MAP.contains(m.listParamTypes()[0].fullName())) {
                        writer.write(varName);
                        writer.write(".");
                        writer.write(m.name());
                        writer.write("(");
                        this.writeDefaultType(writer, m.listParamTypes()[0], path + "/" + m.name().substring(3));
                        writer.write(");");
                        continue;
                    }
                    this.writeDefaultValue(writer, indent, path + "/" + m.name().substring(3), varName + m.name().substring(3), m.listParamTypes()[0]);
                    writer.write("\n");
                    writer.write(indent);
                    writer.write(varName);
                    writer.write(".");
                    writer.write(m.name());
                    writer.write("(");
                    writer.write(varName + m.name().substring(3));
                    writer.write(");");
                    continue;
                }
                if (!m.type().fullName().startsWith("java.util.List")) continue;
                writer.write("\n");
                writer.write(indent);
                this.writeDefaultValue(writer, indent, path + "/" + m.name().substring(3), varName + m.name().substring(3), m.type());
                writer.write("\n");
                writer.write(indent);
                writer.write(varName);
                writer.write(".");
                writer.write(m.name());
                writer.write("().addAll(");
                writer.write(varName + m.name().substring(3));
                writer.write(");");
            }
        }

        private void writeDefaultType(Writer writer, JType t, String path) throws IOException {
            String name = t.fullName();
            this.writeDefaultType(writer, name, path);
        }

        private void writeDefaultType(Writer writer, String name, String path) throws IOException {
            if (JLDEFAULT_TYPE_MAP.containsKey(name)) {
                writer.append(name.substring("java.lang.".length())).append(".valueOf(");
                this.writeDefaultType(writer, (String)JLDEFAULT_TYPE_MAP.get(name), path);
                writer.append(")");
            } else if ("boolean".equals(name)) {
                writer.append(JAXBDataBinding.this.defaultValues.getBooleanValue(path) ? "true" : "false");
            } else if ("int".equals(name)) {
                writer.append(Integer.toString(JAXBDataBinding.this.defaultValues.getIntValue(path)));
            } else if ("long".equals(name)) {
                writer.append(Long.toString(JAXBDataBinding.this.defaultValues.getLongValue(path))).append("l");
            } else if ("short".equals(name)) {
                writer.append("(short)").append(Short.toString(JAXBDataBinding.this.defaultValues.getShortValue(path)));
            } else if ("byte".equals(name)) {
                writer.append("(byte)").append(Byte.toString(JAXBDataBinding.this.defaultValues.getByteValue(path)));
            } else if ("float".equals(name)) {
                writer.append(Float.toString(JAXBDataBinding.this.defaultValues.getFloatValue(path))).append("f");
            } else if ("double".equals(name)) {
                writer.append(Double.toString(JAXBDataBinding.this.defaultValues.getDoubleValue(path)));
            } else if ("char".equals(name)) {
                writer.append("(char)").append(Character.toString(JAXBDataBinding.this.defaultValues.getCharValue(path)));
            } else if ("java.lang.String".equals(name)) {
                writer.append("\"").append(JAXBDataBinding.this.defaultValues.getStringValue(path)).append("\"");
            } else if ("javax.xml.namespace.QName".equals(name)) {
                QName qn = JAXBDataBinding.this.defaultValues.getQNameValue(path);
                writer.append("new javax.xml.namespace.QName(\"").append(qn.getNamespaceURI()).append("\", \"").append(qn.getLocalPart()).append("\")");
            } else if ("java.net.URI".equals(name)) {
                writer.append("new java.net.URI(\"").append(JAXBDataBinding.this.defaultValues.getURIValue(path).toASCIIString()).append("\")");
            } else if ("java.math.BigInteger".equals(name)) {
                writer.append("new java.math.BigInteger(\"").append(JAXBDataBinding.this.defaultValues.getBigIntegerValue(path).toString()).append("\")");
            } else if ("java.math.BigDecimal".equals(name)) {
                writer.append("new java.math.BigDecimal(\"").append(JAXBDataBinding.this.defaultValues.getBigDecimalValue(path).toString()).append("\")");
            } else if ("javax.xml.datatype.XMLGregorianCalendar".equals(name)) {
                writer.append("javax.xml.datatype.DatatypeFactory.newInstance().newXMLGregorianCalendar(\"").append(JAXBDataBinding.this.defaultValues.getXMLGregorianCalendarValueString(path)).append("\")");
            } else if ("javax.xml.datatype.Duration".equals(name)) {
                writer.append("javax.xml.datatype.DatatypeFactory.newInstance().newDuration(\"").append(JAXBDataBinding.this.defaultValues.getDurationValueString(path)).append("\")");
            }
        }
    }
}

