/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.javascript;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.javascript.BasicNameManager;
import org.apache.cxf.javascript.JavascriptQueryHandler;
import org.apache.cxf.javascript.NameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.service.ServiceJavascriptBuilder;
import org.apache.cxf.javascript.types.SchemaJavascriptBuilder;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.wsdlto.core.WSDLToProcessor;

public class WSDLToJavaScriptProcessor
extends WSDLToProcessor {
    private static final Charset UTF8 = Charset.forName("utf-8");

    public void process() throws ToolException {
        super.process();
        ServiceInfo serviceInfo = (ServiceInfo)this.context.get(ServiceInfo.class);
        File jsFile = this.getOutputFile(serviceInfo.getName().getLocalPart() + ".js");
        BasicNameManager nameManager = BasicNameManager.newNameManager((ServiceInfo)serviceInfo, null);
        NamespacePrefixAccumulator prefixManager = new NamespacePrefixAccumulator(serviceInfo.getXmlSchemaCollection());
        List schemata = serviceInfo.getSchemas();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(jsFile);
            if (null != this.context.get("javascriptUtils")) {
                JavascriptQueryHandler.writeUtilsToResponseStream(WSDLToJavaScriptProcessor.class, (OutputStream)fileOutputStream);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, UTF8);
            BufferedWriter writer = new BufferedWriter(outputStreamWriter);
            for (SchemaInfo schema : schemata) {
                SchemaJavascriptBuilder jsBuilder = new SchemaJavascriptBuilder(serviceInfo.getXmlSchemaCollection(), prefixManager, (NameManager)nameManager);
                String allThatJavascript = jsBuilder.generateCodeForSchema(schema);
                writer.append(allThatJavascript);
            }
            ServiceJavascriptBuilder serviceBuilder = new ServiceJavascriptBuilder(serviceInfo, null, prefixManager, (NameManager)nameManager);
            serviceBuilder.walk();
            String serviceJavascript = serviceBuilder.getCode();
            writer.append(serviceJavascript);
            writer.close();
        }
        catch (FileNotFoundException e) {
            throw new ToolException((Throwable)e);
        }
        catch (IOException e) {
            throw new ToolException((Throwable)e);
        }
    }

    private File getOutputFile(String defaultOutputFile) {
        File result;
        String output = (String)this.context.get("outputfile");
        String dir = (String)this.context.get("outputdir");
        if (dir == null) {
            dir = "./";
        }
        if (output != null) {
            result = new File(output);
            if (!result.isAbsolute()) {
                result = new File(new File(dir), output);
            }
        } else {
            result = new File(new File(dir), defaultOutputFile);
        }
        if (result.exists() && !result.renameTo(new File(result.getParent(), result.getName()))) {
            throw new ToolException(new Message("OUTFILE_EXISTS", LOG, new Object[0]));
        }
        return result;
    }
}

