/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Iterator;
import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;

public class ClientGenerator
extends AbstractJAXWSGenerator {
    private static final String CLT_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/client.vm";

    public ClientGenerator() {
        this.name = "clt.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genClient") || this.env.optionSet("client") || this.env.optionSet("all")) {
            return false;
        }
        if (this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genService")) {
            return true;
        }
        return true;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = (JavaModel)this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        if (javaModel.getServiceClasses().size() == 0) {
            ServiceInfo serviceInfo = (ServiceInfo)this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_CLIENT", LOG, new Object[]{wsdl});
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        Map interfaces = javaModel.getInterfaces();
        JavaServiceClass js = null;
        JavaPort jp2 = null;
        for (String interfaceName : interfaces.keySet()) {
            JavaInterface intf = (JavaInterface)interfaces.get(interfaceName);
            Iterator it = javaModel.getServiceClasses().values().iterator();
            while (it.hasNext()) {
                String serviceName = "";
                js = (JavaServiceClass)it.next();
                for (JavaPort jp2 : js.getPorts()) {
                    if (!jp2.getPortType().equals(interfaceName)) continue;
                    serviceName = js.getName();
                    break;
                }
                if ("".equals(serviceName)) continue;
                break;
            }
            String clientClassName = interfaceName + "Client";
            while (this.isCollision(intf.getPackageName(), clientClassName)) {
                clientClassName = clientClassName + "_Client";
            }
            this.clearAttributes();
            this.setAttributes("clientClassName", clientClassName);
            this.setAttributes("intf", intf);
            this.setAttributes("service", js);
            this.setAttributes("port", jp2);
            this.setCommonAttributes();
            this.doWrite(CLT_TEMPLATE, this.parseOutputName(intf.getPackageName(), clientClassName));
        }
    }
}

