/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.customization;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.StAXUtil;
import org.apache.cxf.tools.util.URIParserUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.CustomNodeSelector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;
import org.apache.xml.resolver.Catalog;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizationParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CustomizationParser.class);
    private ToolContext env;
    private final Map<Element, Element> jaxwsBindingsMap = new HashMap<Element, Element>();
    private final List<InputSource> jaxbBindings = new ArrayList<InputSource>();
    private final Map<String, Element> customizedElements = new HashMap<String, Element>();
    private Element handlerChains;
    private Element wsdlNode;
    private String wsdlURL;
    private CustomNodeSelector nodeSelector = new CustomNodeSelector();

    public CustomizationParser() {
        this.jaxwsBindingsMap.clear();
        this.jaxbBindings.clear();
    }

    public Element getHandlerChains() {
        return this.handlerChains;
    }

    public void parse(ToolContext pe) {
        String[] bindingFiles;
        this.env = pe;
        try {
            this.wsdlURL = URIParserUtil.getAbsoluteURI((String)((String)this.env.get("wsdlurl")));
            this.wsdlNode = this.getTargetNode(this.wsdlURL);
            if (this.wsdlNode == null && this.env.get("catalog") != null) {
                this.wsdlNode = this.resolveNodeByCatalog(this.wsdlURL);
            }
            this.customizedElements.put(this.wsdlURL.toString(), this.wsdlNode);
            bindingFiles = (String[])this.env.get("binding");
            if (bindingFiles == null) {
                return;
            }
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)this.env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            try {
                this.addBinding(bindingFiles[i]);
                continue;
            }
            catch (XMLStreamException xse) {
                Message msg = new Message("STAX_PARSER_ERROR", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)xse);
            }
        }
        for (Element element : this.jaxwsBindingsMap.keySet()) {
            Element oldTargetNode;
            this.nodeSelector.addNamespaces(element);
            Element targetNode = oldTargetNode = this.jaxwsBindingsMap.get(element);
            this.internalizeBinding(element, targetNode, "");
            String uri = element.getAttribute("wsdlLocation");
            this.customizedElements.put(uri, targetNode);
            this.updateJaxwsBindingMapValue(targetNode);
        }
        this.buildHandlerChains();
    }

    public Element getTargetNode(String uri) {
        Document doc = null;
        InputStream ins = null;
        try {
            URIResolver resolver = new URIResolver(uri);
            ins = resolver.getInputStream();
        }
        catch (IOException e1) {
            return null;
        }
        if (ins == null) {
            return null;
        }
        try {
            doc = DOMUtils.readXml((InputStream)ins);
            doc.setDocumentURI(uri);
        }
        catch (Exception e) {
            Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, new Object[]{uri});
            throw new ToolException(msg, (Throwable)e);
        }
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    private void updateJaxwsBindingMapValue(Element value) {
        String baseURI = value.getBaseURI();
        for (Element ele : this.jaxwsBindingsMap.keySet()) {
            String uri = this.jaxwsBindingsMap.get(ele).getBaseURI();
            if (uri == null || !uri.equals(baseURI)) continue;
            this.jaxwsBindingsMap.put(ele, value);
        }
    }

    private void buildHandlerChains() {
        for (Element jaxwsBinding : this.jaxwsBindingsMap.keySet()) {
            NodeList nl = jaxwsBinding.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            if (nl.getLength() == 0) continue;
            this.handlerChains = (Element)nl.item(0);
            return;
        }
    }

    private Node[] getAnnotationNodes(Node node) {
        Node[] nodes = new Node[2];
        Node annotationNode = this.nodeSelector.queryNode(node, "//xsd:annotation");
        if (annotationNode == null) {
            annotationNode = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
        }
        nodes[0] = annotationNode;
        Node appinfoNode = this.nodeSelector.queryNode(annotationNode, "//xsd:appinfo");
        if (appinfoNode == null) {
            appinfoNode = node.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
            annotationNode.appendChild(appinfoNode);
        }
        nodes[1] = appinfoNode;
        return nodes;
    }

    private void appendJaxbVersion(Element schemaElement) {
        String jaxbPrefix = schemaElement.lookupPrefix("http://java.sun.com/xml/ns/jaxb");
        if (jaxbPrefix == null) {
            schemaElement.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
            schemaElement.setAttribute("jaxb:version", "2.0");
        }
    }

    protected void copyAllJaxbDeclarations(Node schemaNode, Element jaxwsBindingNode) {
        Element jaxbBindingElement = this.getJaxbBindingElement(jaxwsBindingNode);
        this.appendJaxbVersion((Element)schemaNode);
        if (jaxbBindingElement != null) {
            NodeList nlist = this.nodeSelector.queryNodes(schemaNode, jaxbBindingElement.getAttribute("node"));
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node node = nlist.item(i);
                this.copyAllJaxbDeclarations(node, jaxbBindingElement);
            }
            return;
        }
        Node[] embededNodes = this.getAnnotationNodes(schemaNode);
        Node annotationNode = embededNodes[0];
        Node appinfoNode = embededNodes[1];
        NodeList childNodes = jaxwsBindingNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!this.isJaxbBindings(childNode) || this.isJaxbBindingsElement(childNode)) continue;
            Node jaxbNode = childNode;
            Node cloneNode = ProcessorUtil.cloneNode(schemaNode.getOwnerDocument(), jaxbNode, true);
            appinfoNode.appendChild(cloneNode);
        }
        if (schemaNode.getChildNodes().getLength() > 0) {
            schemaNode.insertBefore(annotationNode, schemaNode.getChildNodes().item(0));
        } else {
            schemaNode.appendChild(annotationNode);
        }
    }

    protected void internalizeBinding(Element bindings, Element targetNode, String expression) {
        if (bindings.getAttributeNode("wsdlLocation") != null) {
            expression = "/";
        }
        if (this.isGlobaleBindings(bindings)) {
            String pfx = targetNode.getPrefix();
            pfx = pfx == null ? "" : pfx + ":";
            this.nodeSelector.addNamespaces(this.wsdlNode);
            Node node = this.nodeSelector.queryNode(targetNode, "//" + pfx + "definitions");
            this.copyBindingsToWsdl(node, bindings, this.nodeSelector.getNamespaceContext());
        }
        if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") != null) {
            expression = expression + "/" + bindings.getAttribute("node");
            this.nodeSelector.addNamespaces(bindings);
            NodeList nodeList = this.nodeSelector.queryNodes(targetNode, expression);
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new ToolException(new Message("NODE_NOT_EXISTS", LOG, new Object[]{expression}));
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (this.hasJaxbBindingDeclaration(bindings)) {
                    this.copyAllJaxbDeclarations(node, bindings);
                    continue;
                }
                this.copyBindingsToWsdl(node, bindings, this.nodeSelector.getNamespaceContext());
            }
        }
        Element[] children = this.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxws");
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getNodeType() != 1) continue;
            this.internalizeBinding(children[i], targetNode, expression);
        }
    }

    private void copyBindingsToWsdl(Node node, Node bindings, MapNamespaceContext ctx) {
        if (bindings.getNamespaceURI().equals(ToolConstants.JAXWS_BINDINGS.getNamespaceURI())) {
            bindings.setPrefix("jaxws");
        }
        for (Map.Entry ent : ctx.getUsedNamespaces().entrySet()) {
            if (node.lookupNamespaceURI((String)ent.getKey()) != null) continue;
            node.getOwnerDocument().getDocumentElement().setAttribute("xmlns:" + (String)ent.getKey(), (String)ent.getValue());
        }
        for (int i = 0; i < bindings.getChildNodes().getLength(); ++i) {
            Node childNode = bindings.getChildNodes().item(i);
            if (childNode.getNodeType() != 1 || !childNode.getNamespaceURI().equals(ToolConstants.JAXWS_BINDINGS.getNamespaceURI())) continue;
            childNode.setPrefix("jaxws");
        }
        Node cloneNode = ProcessorUtil.cloneNode(node.getOwnerDocument(), bindings, true);
        Node firstChild = DOMUtils.getChild((Node)node, (String)"jaxws:bindings");
        if (firstChild == null && cloneNode.getNodeName().indexOf("bindings") == -1) {
            this.wsdlNode.setAttribute("xmlns:jaxws", ToolConstants.JAXWS_BINDINGS.getNamespaceURI());
            Element jaxwsBindingElement = node.getOwnerDocument().createElement("jaxws:bindings");
            node.appendChild(jaxwsBindingElement);
            firstChild = jaxwsBindingElement;
        }
        if (firstChild == null && cloneNode.getNodeName().indexOf("bindings") > -1) {
            firstChild = node;
            if (this.wsdlNode.getAttributeNode("xmls:jaxws") == null) {
                this.wsdlNode.setAttribute("xmlns:jaxws", ToolConstants.JAXWS_BINDINGS.getNamespaceURI());
            }
        }
        Element cloneEle = (Element)cloneNode;
        cloneEle.removeAttribute("node");
        for (int i = 0; i < cloneNode.getChildNodes().getLength(); ++i) {
            Element childElement;
            Attr attrNode;
            Node child = cloneNode.getChildNodes().item(i);
            if (child.getNodeType() != 1 || (attrNode = (childElement = (Element)child).getAttributeNode("node")) == null) continue;
            cloneNode.removeChild(child);
        }
        firstChild.appendChild(cloneNode);
    }

    private boolean isGlobaleBindings(Element binding) {
        Element ele;
        boolean globleNode = binding.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws") && binding.getLocalName().equals("package") || binding.getLocalName().equals("enableAsyncMapping") || binding.getLocalName().equals("enableAdditionalSOAPHeaderMapping") || binding.getLocalName().equals("enableWrapperStyle") || binding.getLocalName().equals("enableMIMEContent");
        Node parentNode = binding.getParentNode();
        return parentNode instanceof Element && (ele = (Element)parentNode).getAttributeNode("wsdlLocation") != null && globleNode;
    }

    private Element[] getChildElements(Element parent, String nsUri) {
        ArrayList<Element> a = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (!(item instanceof Element) || !nsUri.equals(item.getNamespaceURI())) continue;
            a.add((Element)item);
        }
        return a.toArray(new Element[a.size()]);
    }

    private void addBinding(String bindingFile) throws XMLStreamException {
        InputSource is = new InputSource(bindingFile);
        XMLStreamReader reader = StAXUtil.createFreshXMLStreamReader((InputSource)is);
        StAXUtil.toStartTag((XMLStreamReader)reader);
        Element root = null;
        try {
            URIResolver resolver = new URIResolver(bindingFile);
            root = DOMUtils.readXml((InputStream)resolver.getInputStream()).getDocumentElement();
        }
        catch (Exception e1) {
            Message msg = new Message("CAN_NOT_READ_AS_ELEMENT", LOG, new Object[]{bindingFile});
            throw new ToolException(msg, (Throwable)e1);
        }
        if (this.isValidJaxwsBindingFile(bindingFile, reader)) {
            String wsdlLocation = root.getAttribute("wsdlLocation");
            Element targetNode = null;
            if (!StringUtils.isEmpty((String)wsdlLocation)) {
                String wsdlURI = this.getAbsoluteURI(wsdlLocation, bindingFile);
                targetNode = this.getTargetNode(wsdlURI);
                String resolvedLoc = wsdlURI;
                if (targetNode == null && this.env.get("catalog") != null) {
                    resolvedLoc = this.resolveByCatalog(wsdlURI.toString());
                    targetNode = this.getTargetNode(resolvedLoc);
                }
                if (targetNode == null) {
                    Message msg = new Message("POINT_TO_WSDL_DOES_NOT_EXIST", LOG, new Object[]{bindingFile, resolvedLoc});
                    throw new ToolException(msg);
                }
                root.setAttribute("wsdlLocation", wsdlURI);
            } else {
                targetNode = this.wsdlNode;
                root.setAttribute("wsdlLocation", this.wsdlURL);
            }
            this.jaxwsBindingsMap.put(root, targetNode);
        } else if (this.isValidJaxbBindingFile(reader)) {
            String schemaLocation = root.getAttribute("schemaLocation");
            boolean hasJaxbBindingChild = false;
            NodeList nlist = root.getElementsByTagNameNS(ToolConstants.JAXB_BINDINGS.getNamespaceURI(), ToolConstants.JAXB_BINDINGS.getLocalPart());
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node node = nlist.item(i);
                if (!(node instanceof Element)) continue;
                hasJaxbBindingChild = true;
                break;
            }
            if (StringUtils.isEmpty((String)schemaLocation) && !hasJaxbBindingChild) {
                InputSource tmpIns = null;
                try {
                    tmpIns = this.convertToTmpInputSource(root, this.wsdlURL);
                }
                catch (Exception e1) {
                    Message msg = new Message("FAILED_TO_ADD_SCHEMALOCATION", LOG, new Object[]{bindingFile});
                    throw new ToolException(msg, (Throwable)e1);
                }
                this.jaxbBindings.add(tmpIns);
            } else {
                this.jaxbBindings.add(is);
            }
        } else {
            Message msg = new Message("UNKNOWN_BINDING_FILE", LOG, new Object[]{bindingFile});
            throw new ToolException(msg);
        }
    }

    private String getAbsoluteURI(String uri, String bindingFile) {
        URI locURI = null;
        try {
            locURI = new URI(uri);
        }
        catch (URISyntaxException e) {
            Message msg = new Message("BINDING_LOC_ERROR", LOG, new Object[]{uri});
            throw new ToolException(msg);
        }
        if (!locURI.isAbsolute()) {
            try {
                String base = URIParserUtil.getAbsoluteURI((String)bindingFile);
                URI baseURI = new URI(base);
                locURI = baseURI.resolve(locURI);
            }
            catch (URISyntaxException e) {
                Message msg = new Message("NOT_URI", LOG, new Object[]{bindingFile});
                throw new ToolException(msg, (Throwable)e);
            }
        }
        return locURI.toString();
    }

    private Element resolveNodeByCatalog(String url) {
        String resolvedLocation = this.resolveByCatalog(url);
        return this.getTargetNode(resolvedLocation);
    }

    private String resolveByCatalog(String url) {
        String resolvedLocation;
        Bus bus = (Bus)this.env.get(Bus.class);
        Catalog catalogResolver = OASISCatalogManager.getCatalogManager((Bus)bus).getCatalog();
        try {
            resolvedLocation = catalogResolver.resolveSystem(url);
            if (resolvedLocation == null) {
                resolvedLocation = catalogResolver.resolveURI(url);
            }
        }
        catch (Exception e1) {
            Message msg = new Message("FAILED_RESOLVE_CATALOG", LOG, new Object[]{url});
            throw new ToolException(msg, (Throwable)e1);
        }
        return resolvedLocation;
    }

    private InputSource convertToTmpInputSource(Element ele, String schemaLoc) throws Exception {
        InputSource result = null;
        ele.setAttribute("schemaLocation", schemaLoc);
        File tmpFile = FileUtils.createTempFile((String)"jaxbbinding", (String)".xml");
        XMLUtils.writeTo((Node)ele, (OutputStream)new FileOutputStream(tmpFile));
        result = new InputSource(URIParserUtil.getAbsoluteURI((String)tmpFile.getAbsolutePath()));
        tmpFile.deleteOnExit();
        return result;
    }

    private boolean isValidJaxbBindingFile(XMLStreamReader reader) {
        return ToolConstants.JAXB_BINDINGS.equals(reader.getName());
    }

    private boolean isValidJaxwsBindingFile(String bindingLocation, XMLStreamReader reader) {
        return ToolConstants.JAXWS_BINDINGS.equals(reader.getName());
    }

    protected void setWSDLNode(Element node) {
        this.wsdlNode = node;
    }

    public Node getWSDLNode() {
        return this.wsdlNode;
    }

    private boolean isJAXWSBindings(Node bindings) {
        return "http://java.sun.com/xml/ns/jaxws".equals(bindings.getNamespaceURI()) && "bindings".equals(bindings.getLocalName());
    }

    private boolean isJaxbBindings(Node bindings) {
        return "http://java.sun.com/xml/ns/jaxb".equals(bindings.getNamespaceURI());
    }

    private boolean isJaxbBindingsElement(Node bindings) {
        return "bindings".equals(bindings.getLocalName());
    }

    protected Element getJaxbBindingElement(Element bindings) {
        NodeList list = bindings.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "bindings");
        if (list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    protected boolean hasJaxbBindingDeclaration(Node bindings) {
        NodeList childNodes = bindings.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!this.isJaxbBindings(childNode)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Element> getCustomizedWSDLElements() {
        return this.customizedElements;
    }

    public List<InputSource> getJaxbBindings() {
        return this.jaxbBindings;
    }

    public static JAXWSBinding mergeJawsBinding(JAXWSBinding binding1, JAXWSBinding binding2) {
        if (binding1 != null && binding2 != null) {
            if (binding2.isEnableAsyncMapping()) {
                binding1.setEnableAsyncMapping(true);
            }
            if (binding2.isEnableWrapperStyle()) {
                binding1.setEnableWrapperStyle(true);
            }
            if (binding2.isEnableMime()) {
                binding1.setEnableMime(true);
            }
            if (binding2.getJaxwsClass() != null) {
                binding1.setJaxwsClass(binding2.getJaxwsClass());
            }
            if (binding2.getJaxwsPara() != null) {
                binding1.setJaxwsPara(binding2.getJaxwsPara());
            }
            return binding1;
        }
        return binding1 == null ? binding2 : binding1;
    }
}

