/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.util.Map;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaPort;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;

public class ServerGenerator
extends AbstractJAXWSGenerator {
    private static final String SRV_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/server.vm";

    public ServerGenerator() {
        this.name = "svr.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genServer") || this.env.optionSet("server") || this.env.optionSet("all")) {
            return false;
        }
        if (this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genService") || this.env.optionSet("genFault")) {
            return true;
        }
        return true;
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = (JavaModel)this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        String address = "CHANGE_ME";
        Map interfaces = javaModel.getInterfaces();
        if (javaModel.getServiceClasses().size() == 0) {
            ServiceInfo serviceInfo = (ServiceInfo)this.env.get(ServiceInfo.class);
            String wsdl = serviceInfo.getDescription().getBaseURI();
            Message msg = new Message("CAN_NOT_GEN_SRV", LOG, new Object[]{wsdl});
            if (penv.isVerbose()) {
                System.out.println(msg.toString());
            }
            return;
        }
        for (JavaServiceClass js : javaModel.getServiceClasses().values()) {
            for (JavaPort jp : js.getPorts()) {
                String interfaceName = jp.getInterfaceClass();
                JavaInterface intf = (JavaInterface)interfaces.get(interfaceName);
                if (intf == null) {
                    interfaceName = jp.getPortType();
                    intf = (JavaInterface)interfaces.get(interfaceName);
                }
                address = StringUtils.isEmpty((String)jp.getBindingAdress()) ? address : jp.getBindingAdress();
                String serverClassName = interfaceName + "_" + NameUtil.mangleNameToClassName((String)jp.getPortName()) + "_Server";
                this.clearAttributes();
                this.setAttributes("serverClassName", serverClassName);
                this.setAttributes("intf", intf);
                if (penv.optionSet("implClass")) {
                    this.setAttributes("impl", (String)penv.get("implClass"));
                } else {
                    this.setAttributes("impl", intf.getName() + "Impl");
                }
                this.setAttributes("address", address);
                this.setCommonAttributes();
                this.doWrite(SRV_TEMPLATE, this.parseOutputName(intf.getPackageName(), serverClassName));
            }
        }
    }

    public void register(ClassCollector collector, String packageName, String fileName) {
        collector.addServerClassName(packageName, fileName, packageName + "." + fileName);
    }
}

