/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws;

import java.io.IOException;
import java.util.Set;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.wsdlto.WSDLToJavaContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSContainer
extends WSDLToJavaContainer {
    private static final String TOOL_NAME = "wsdl2java";

    public JAXWSContainer(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    public Set<String> getArrayKeys() {
        Set set = super.getArrayKeys();
        set.add("binding");
        return set;
    }

    public void validate(ToolContext env) throws ToolException {
        super.validate(env);
        if (env.containsKey("binding")) {
            String[] bindings = (String[])env.get("binding");
            URIResolver resolver = null;
            for (int i = 0; i < bindings.length; ++i) {
                try {
                    resolver = new URIResolver(bindings[i]);
                }
                catch (IOException ioe) {
                    throw new ToolException((Throwable)ioe);
                }
                if (resolver.isResolved()) continue;
                Message msg = new Message("FILE_NOT_EXIST", LOG, new Object[]{bindings[i]});
                throw new ToolException(msg);
            }
            env.put("binding", (Object)bindings);
        }
    }
}

