/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaExceptionClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.NameUtil;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultProcessor
extends AbstractProcessor {
    private ClassCollector collector;

    public FaultProcessor(ToolContext penv) {
        super(penv);
        this.collector = (ClassCollector)penv.get(ClassCollector.class);
    }

    public void process(JavaMethod method, Collection<FaultInfo> faults) throws ToolException {
        if (faults == null) {
            return;
        }
        for (FaultInfo fault : faults) {
            this.processFault(method, fault);
        }
    }

    private boolean isNameCollision(String packageName, String className) {
        if (this.context.optionSet("overwrite")) {
            return false;
        }
        boolean collision = this.collector.containTypesClass(packageName, className) || this.collector.containSeiClass(packageName, className);
        return collision;
    }

    private void processFault(JavaMethod method, FaultInfo faultMessage) throws ToolException {
        JAXWSBinding jaxwsBinding;
        JavaModel model = method.getInterface().getJavaModel();
        String name = NameUtil.mangleNameToClassName((String)faultMessage.getName().getLocalPart());
        String namespace = faultMessage.getName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName(namespace, this.context.mapPackageName(namespace));
        if (namespace.equals(method.getInterface().getNamespace())) {
            packageName = method.getInterface().getPackageName();
        }
        if ((jaxwsBinding = (JAXWSBinding)faultMessage.getExtensor(JAXWSBinding.class)) != null) {
            if (jaxwsBinding.getPackage() != null) {
                packageName = jaxwsBinding.getPackage();
            }
            if (jaxwsBinding.getJaxwsClass() != null && jaxwsBinding.getJaxwsClass().getClassName() != null) {
                name = jaxwsBinding.getJaxwsClass().getClassName();
            }
        }
        while (this.isNameCollision(packageName, name)) {
            name = name + "_Exception";
        }
        String fullClassName = packageName + "." + name;
        this.collector.addExceptionClassName(packageName, name, fullClassName);
        boolean samePackage = method.getInterface().getPackageName().equals(packageName);
        method.addException(new JavaException(faultMessage.getName().getLocalPart(), samePackage ? name : fullClassName, namespace));
        List faultParts = faultMessage.getMessageParts();
        JavaExceptionClass expClass = new JavaExceptionClass(model);
        expClass.setName(name);
        expClass.setNamespace(namespace);
        expClass.setPackageName(packageName);
        for (MessagePartInfo part : faultParts) {
            String fName = null;
            String fNamespace = null;
            if (part.getElementQName() != null) {
                fNamespace = part.getElementQName().getNamespaceURI();
                fName = part.getConcreteName().getLocalPart();
            } else {
                fNamespace = part.getTypeQName().getNamespaceURI();
                fName = part.getConcreteName().getLocalPart();
            }
            if (StringUtils.isEmpty((String)fNamespace)) {
                fNamespace = namespace;
            }
            String fType = ProcessorUtil.getType(part, this.context, false);
            String fPackageName = method.getInterface().getPackageName();
            JavaField fField = new JavaField(fName, fType, fNamespace);
            fField.setQName(ProcessorUtil.getElementName(part));
            if (!method.getInterface().getPackageName().equals(fPackageName)) {
                fField.setClassName(ProcessorUtil.getFullClzName(part, this.context, false));
            }
            if (!fType.equals(ProcessorUtil.resolvePartType(part))) {
                fField.setClassName(ProcessorUtil.getType(part, this.context, true));
            }
            expClass.addField(fField);
        }
        model.addExceptionClass(packageName + "." + name, expClass);
    }
}

