/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wadlto;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.maven_plugin.common.DocumentArtifact;
import org.apache.cxf.maven_plugin.wadlto.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlOption
extends Option {
    String wadl;
    DocumentArtifact wadlArtifact;

    public String getWadl() {
        return this.wadl;
    }

    public void setWadl(String w) {
        this.wadl = w;
    }

    public DocumentArtifact getWadlArtifact() {
        return this.wadlArtifact;
    }

    public void setWadlArtifact(DocumentArtifact wadlArtifact) {
        this.wadlArtifact = wadlArtifact;
    }

    public File getDocumentFile(File baseDir) {
        if (this.wadl == null) {
            return null;
        }
        File file = null;
        try {
            URI uri = new URI(this.wadl);
            if (uri.isAbsolute()) {
                file = new File(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || !file.exists()) {
            file = new File(this.wadl);
        }
        if (!file.exists()) {
            file = new File(baseDir, this.wadl);
        }
        return file;
    }

    public URI getWadlURI(URI baseURI) {
        String wadlLocation = this.getWadl();
        File wadlFile = new File(wadlLocation);
        return wadlFile.exists() ? wadlFile.toURI() : baseURI.resolve(URIParserUtil.escapeChars((String)wadlLocation));
    }

    public int hashCode() {
        if (this.wadl != null) {
            return this.wadl.hashCode();
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WadlOption)) {
            return false;
        }
        WadlOption t = (WadlOption)obj;
        return t.getWadl().equals(this.getWadl());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WADL: ").append(this.wadl).append('\n');
        builder.append("OutputDir: ").append(this.outputDir).append('\n');
        builder.append('\n');
        return builder.toString();
    }

    public List<String> generateCommandLine(File outputDirFile, URI basedir, URI wsdlURI, boolean debug) {
        ArrayList<String> list = new ArrayList<String>();
        WadlOption.addIfNotNull(list, outputDirFile, "-d");
        for (String binding : this.getBindingFiles()) {
            File bindingFile = new File(binding);
            URI bindingURI = bindingFile.exists() ? bindingFile.toURI() : basedir.resolve(binding);
            list.add("-b");
            list.add(bindingURI.toString());
        }
        WadlOption.addIfNotNull(list, this.getCatalog(), "-catalog");
        WadlOption.addIfNotNull(list, this.getResourcename(), "-resource");
        WadlOption.addIfNotNull(list, this.getPackagename(), "-p");
        WadlOption.addList(list, "-sp", true, this.getSchemaPackagenames());
        WadlOption.addIfTrue(list, this.isImpl(), "-impl");
        WadlOption.addIfTrue(list, this.isInterface(), "-interface");
        WadlOption.addList(list, "", false, this.getExtraargs());
        list.add(wsdlURI.toString());
        return list;
    }

    private static void addIfNotNull(List<String> list, Object value, String key) {
        if (value != null) {
            list.add(key);
            list.add(value.toString());
        }
    }

    private static void addList(List<String> destList, String key, boolean keyAsOwnElement, List<String> sourceList) {
        if (sourceList == null) {
            return;
        }
        for (String value : sourceList) {
            if (keyAsOwnElement) {
                destList.add(key);
                destList.add(value);
                continue;
            }
            destList.add(key + (value == null ? "" : value));
        }
    }

    private static void addIfTrue(List<String> list, boolean expression, String key) {
        if (expression) {
            list.add(key);
        }
    }
}

