/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xsdvalidation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.cxf.xsdvalidation.DOMLSInput;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

class XercesSchemaValidationUtils {
    private XSImplementation impl;

    XercesSchemaValidationUtils() {
        DOMXSImplementationSourceImpl source = new DOMXSImplementationSourceImpl();
        this.impl = (XSImplementation)source.getDOMImplementation("XS-Loader");
    }

    void tryToParseSchemas(XmlSchemaCollection collection, DOMErrorHandler handler) throws XmlSchemaSerializer.XmlSchemaSerializerException, TransformerException {
        ArrayList<DOMLSInput> inputs = new ArrayList<DOMLSInput>();
        final HashMap<String, DOMLSInput> resolverMap = new HashMap<String, DOMLSInput>();
        for (XmlSchema schema : collection.getXmlSchemas()) {
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            Document document = new XmlSchemaSerializer().serializeSchema(schema, false)[0];
            DOMLSInput input = new DOMLSInput(document, schema.getTargetNamespace());
            resolverMap.put(schema.getTargetNamespace(), input);
            inputs.add(input);
        }
        XSLoader schemaLoader = this.impl.createXSLoader(null);
        schemaLoader.getConfig().setParameter("validate", Boolean.TRUE);
        schemaLoader.getConfig().setParameter("error-handler", handler);
        schemaLoader.getConfig().setParameter("resource-resolver", new LSResourceResolver(){

            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                return (LSInput)resolverMap.get(namespaceURI);
            }
        });
        schemaLoader.loadInputList((LSInputList)new ListLSInput(inputs));
    }

    private static final class ListLSInput
    extends ArrayList
    implements LSInputList {
        private static final long serialVersionUID = 1L;

        private ListLSInput(List inputs) {
            super(inputs);
        }

        public int getLength() {
            return this.size();
        }

        public LSInput item(int index) {
            return (LSInput)this.get(index);
        }
    }
}

