/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.servlet.jetty;

import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public abstract class AbstractJettyServer
extends AbstractBusTestServerBase {
    private Server server;
    private final Resource[] resources;
    private final String contextPath;
    private final int port;

    protected AbstractJettyServer(String contextPath, Resource[] resources, int portNumber) {
        this.contextPath = contextPath;
        this.resources = resources;
        this.port = portNumber;
    }

    protected void run() {
        this.server = new Server(this.port);
        try {
            WebAppContext context = new WebAppContext();
            context.setContextPath(this.contextPath);
            context.setConfigurations(new Configuration[]{new WebXmlConfiguration(), new AnnotationConfiguration()});
            for (Resource resource : this.resources) {
                context.getMetaData().addContainerResource(resource);
            }
            this.configureContext(context);
            this.server.setHandler((Handler)context);
            this.configureServer(this.server);
            this.server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AbstractJettyServer.fail((String)ex.getMessage());
        }
    }

    protected void configureServer(Server theserver) throws Exception {
    }

    protected void configureContext(WebAppContext context) throws Exception {
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }
}

