/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.servlet;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.demo.resources.Book;
import org.junit.Test;

public abstract class AbstractSciTest
extends AbstractBusClientServerTestBase {
    public static final Boolean JAVA6_ACTIVE = AbstractSciTest.isJava6();

    private static boolean isJava6() {
        String version = System.getProperty("java.version");
        return 1.6 == Double.parseDouble(version.substring(0, 3));
    }

    protected static void startServers(Class<?> serverClass) throws Exception {
        if (JAVA6_ACTIVE.booleanValue()) {
            return;
        }
        AbstractResourceInfo.clearAllMaps();
        AbstractSciTest.assertTrue((String)"server did not launch correctly", (boolean)AbstractSciTest.launchServer(serverClass, (boolean)true));
        AbstractSciTest.createStaticBus();
    }

    @Test
    public void testResponseHasBeenReceivedWhenQueringBook() {
        if (JAVA6_ACTIVE.booleanValue()) {
            return;
        }
        Response r = this.createWebClient("/bookstore/books").path((Object)"1").get();
        AbstractSciTest.assertEquals((long)Response.Status.OK.getStatusCode(), (long)r.getStatus());
        Book book = (Book)r.readEntity(Book.class);
        AbstractSciTest.assertEquals((Object)"1", (Object)book.getId());
    }

    protected WebClient createWebClient(String url) {
        List<JacksonJsonProvider> providers = Arrays.asList(new JacksonJsonProvider());
        WebClient wc = WebClient.create((String)("http://localhost:" + this.getPort()), providers).path((Object)this.getContextPath()).path((Object)url).accept(new String[]{"application/json"});
        WebClient.getConfig((Object)wc).getHttpConduit().getClient().setReceiveTimeout(10000000L);
        return wc;
    }

    protected abstract int getPort();

    protected abstract String getContextPath();
}

