/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.net.URISyntaxException;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public abstract class AbstractSpringServer
extends AbstractBusTestServerBase {
    private Server server;
    private String resourcePath;
    private String contextPath;
    private int port;

    protected AbstractSpringServer(String path) {
        this(path, "/", 9080);
    }

    protected AbstractSpringServer(String path, int portNumber) {
        this(path, "/", portNumber);
    }

    protected AbstractSpringServer(String path, String cPath, int portNumber) {
        this.resourcePath = path;
        this.contextPath = "/";
        this.port = portNumber;
    }

    protected void run() {
        System.out.println("Starting Server");
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        WebAppContext webappcontext = new WebAppContext();
        webappcontext.setContextPath(this.contextPath);
        String warPath = null;
        try {
            warPath = ((Object)((Object)this)).getClass().getResource(this.resourcePath).toURI().getPath();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        webappcontext.setWar(warPath);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{webappcontext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        try {
            this.server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tearDown() throws Exception {
        super.tearDown();
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }
}

