/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.jaxrs.provider.XSLTJaxbProvider;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookServer;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.CD;
import org.apache.cxf.systest.jaxrs.CDs;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSClientServerBookTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerBookTest.launchServer(BookServer.class));
    }

    @Test
    public void testPropogateException() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/propogateexception", "", "application/xml", 500);
    }

    @Test
    public void testPropogateException2() throws Exception {
        String data = "<ns1:XMLFault xmlns:ns1=\"http://cxf.apache.org/bindings/xformat\"><ns1:faultstring xmlns:ns1=\"http://cxf.apache.org/bindings/xformat\">org.apache.cxf.systest.jaxrs.BookNotFoundFault: Book Exception</ns1:faultstring></ns1:XMLFault>";
        this.getAndCompare("http://localhost:9080/bookstore/propogateexception2", data, "application/xml", 500);
    }

    @Test
    public void testWebApplicationException() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/webappexception", "This is a WebApplicationException", "application/xml", 500);
    }

    @Test
    public void testAddBookProxyResponse() {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Book b = new Book("CXF rocks", 123L);
        Response r = store.addBook(b);
        JAXRSClientServerBookTest.assertNotNull((Object)r);
        InputStream is = (InputStream)r.getEntity();
        JAXRSClientServerBookTest.assertNotNull((Object)is);
        XMLSource source = new XMLSource(is);
        source.setBuffering(true);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)Long.parseLong(source.getValue("Book/id")));
        JAXRSClientServerBookTest.assertEquals((Object)"CXF rocks", (Object)source.getValue("Book/name"));
    }

    @Test
    public void testGetBookCollection() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        ArrayList<Book> books = new ArrayList<Book>();
        books.add(b1);
        books.add(b2);
        List<Book> books2 = store.getBookCollection(books);
        JAXRSClientServerBookTest.assertNotNull(books2);
        JAXRSClientServerBookTest.assertNotSame(books, books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.size());
        Book b11 = (Book)books.get(0);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = (Book)books.get(1);
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
    }

    @Test
    public void testGetBookArray() throws Exception {
        BookStore store = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Book b1 = new Book("CXF in Action", 123L);
        Book b2 = new Book("CXF Rocks", 124L);
        Book[] books = new Book[]{b1, b2};
        Book[] books2 = store.getBookArray(books);
        JAXRSClientServerBookTest.assertNotNull((Object)books2);
        JAXRSClientServerBookTest.assertNotSame((Object)books, (Object)books2);
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)books2.length);
        Book b11 = books2[0];
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)b11.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF in Action", (Object)b11.getName());
        Book b22 = books2[1];
        JAXRSClientServerBookTest.assertEquals((long)124L, (long)b22.getId());
        JAXRSClientServerBookTest.assertEquals((Object)"CXF Rocks", (Object)b22.getName());
    }

    @Test
    public void testGetBookByURL() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/bookurl/http%3A%2F%2Ftest.com%2Frss%2F123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testHeadBookByURL() throws Exception {
        WebClient wc = WebClient.create((String)"http://localhost:9080/bookstore/bookurl/http%3A%2F%2Ftest.com%2Frss%2F123");
        Response response = wc.head();
        JAXRSClientServerBookTest.assertTrue((response.getMetadata().size() != 0 ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
    }

    @Test
    public void testWebClientUnwrapBookWithXslt() throws Exception {
        XSLTJaxbProvider provider = new XSLTJaxbProvider();
        provider.setInTemplate("classpath:/org/apache/cxf/systest/jaxrs/resources/unwrapbook.xsl");
        WebClient wc = WebClient.create((String)"http://localhost:9080/bookstore/books/wrapper", Collections.singletonList(provider));
        wc.path("{id}", new Object[]{123});
        Book book = (Book)wc.get(Book.class);
        JAXRSClientServerBookTest.assertNotNull((Object)book);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    @Ignore
    public void testProxyUnwrapBookWithXslt() throws Exception {
        XSLTJaxbProvider provider = new XSLTJaxbProvider();
        provider.setInTemplate("classpath:/org/apache/cxf/systest/jaxrs/resources/unwrapbook2.xsl");
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class, Collections.singletonList(provider));
        Book book = bs.getWrappedBook2(123L);
        JAXRSClientServerBookTest.assertNotNull((Object)book);
        JAXRSClientServerBookTest.assertEquals((long)123L, (long)book.getId());
    }

    @Test
    public void testOptions() throws Exception {
        WebClient wc = WebClient.create((String)"http://localhost:9080/bookstore/bookurl/http%3A%2F%2Ftest.com%2Frss%2F123");
        Response response = wc.options();
        List values = (List)response.getMetadata().get((Object)"Allow");
        JAXRSClientServerBookTest.assertNotNull((Object)values);
        JAXRSClientServerBookTest.assertTrue((values.contains("POST") && values.contains("GET") && values.contains("DELETE") && values.contains("PUT") ? 1 : 0) != 0);
        JAXRSClientServerBookTest.assertEquals((long)0L, (long)((InputStream)response.getEntity()).available());
    }

    @Test
    public void testGetBookByEncodedQuery() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/bookquery?urlid=http%3A%2F%2Ftest.com%2Frss%2F123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetGenericBook() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/genericbooks/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetGenericResponseBook() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/genericresponse/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByArrayQuery() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/bookidarray?id=1&id=2&id=3", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testNoRootResourceException() throws Exception {
        this.getAndCompare("http://localhost:9080/nobookstore/webappexception", "", "application/xml", 404);
    }

    @Test
    public void testNoPathMatch() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/bookqueries", "", "application/xml", 404);
    }

    @Test
    public void testWriteAndFailEarly() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/books/fail-early", "This is supposed to go on the wire", "application/bar, text/plain", 410);
    }

    @Test
    public void testWriteAndFailLate() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/books/fail-late", "", "application/bar", 410);
    }

    @Test
    public void testAcceptTypeMismatch() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/booknames/123", "", "foo/bar", 406);
    }

    @Test
    public void testWrongHttpMethod() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/unsupportedcontenttype", "", "foo/bar", 405);
    }

    @Test
    public void testWrongQueryParameterType() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/wrongparametertype?p=1", "Parameter Class java.util.Map has no constructor with single String parameter, static valueOf(String) or fromString(String) methods", "*/*", 500);
    }

    @Test
    public void testExceptionDuringConstruction() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/exceptionconstruction?p=1", "", "foo/bar", 404);
    }

    @Test
    public void testSubresourceMethodNotFound() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/interface/thesubresource", "", "foo/bar", 404);
    }

    @Test
    public void testNoMessageWriterFound() throws Exception {
        String msg1 = ".No message body writer found for response class : GregorianCalendar.";
        String msg2 = ".No message body writer found for response class : Calendar.";
        this.getAndCompareStrings("http://localhost:9080/bookstore/timetable", new String[]{msg1, msg2}, "*/*", 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoMessageReaderFound() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/binarybooks";
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", "application/octet-stream");
        post.setRequestHeader("Accept", "text/xml");
        post.setRequestBody("Bar");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)415L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumeTypeMismatch() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/unsupportedcontenttype";
        PostMethod post = new PostMethod(endpointAddress);
        post.setRequestHeader("Content-Type", "application/bar");
        post.setRequestHeader("Accept", "text/xml");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)415L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testBookExists() throws Exception {
        this.checkBook("http://localhost:9080/bookstore/books/check/123", true);
        this.checkBook("http://localhost:9080/bookstore/books/check/125", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBook(String address, boolean expected) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", "text/plain");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            if (expected) {
                JAXRSClientServerBookTest.assertEquals((String)"Book must be available", (Object)"true", (Object)get.getResponseBodyAsString());
            } else {
                JAXRSClientServerBookTest.assertEquals((String)"Book must not be available", (Object)"false", (Object)get.getResponseBodyAsString());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    @Test
    public void testGetBookCustomExpression() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/custom/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123WebClient() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Book b = bs.getBook("123");
        JAXRSClientServerBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testDeleteWithWebClient() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Response r = bs.deleteBook("123");
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
    }

    @Test
    public void testCreatePut() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Response r = bs.createBook(777L);
        JAXRSClientServerBookTest.assertEquals((long)200L, (long)r.getStatus());
    }

    @Test
    public void testUpdateWithWebClient() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"http://localhost:9080", BookStore.class);
        Book book = new Book();
        book.setId(888L);
        bs.updateBook(book);
        JAXRSClientServerBookTest.assertEquals((long)304L, (long)WebClient.client((Object)bs).getResponse().getStatus());
    }

    @Test
    public void testGetBookTypeAndWildcard() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml;q=0.8,*/*", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123.txt", "application/*", "application/xml", 200);
    }

    @Test
    public void testGetBook123() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/query?bookId=123", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/defaultquery", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/missingquery", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123json.txt", "application/json, application/xml", "application/json", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml, application/json", "application/xml", 200);
    }

    @Test
    public void testGetBookXmlWildcard() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123.txt", "*/*", "application/xml", 200);
    }

    @Test
    public void testGetBookBuffer() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/buffer", "resources/expected_get_book123.txt", "application/bar", 200);
    }

    @Test
    public void testGetBookBySegment() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/segment/matrix2;first=12;second=3", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore;bar/segment;foo/matrix2;first=12;second=3;third", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByListOfSegments() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/segment/list/1/2/3", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByMatrixParameters() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/segment/matrix;first=12;second=3", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore;bar;first=12/segment;foo;second=3/matrix;third", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookByHeader() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/bookheaders", "resources/expected_get_book123.txt", "application/xml;q=0.5,text/xml", "text/xml", 200);
    }

    @Test
    public void testGetBookByHeaderPerRequest() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore2/bookheaders", "resources/expected_get_book123.txt", "application/xml;q=0.5,text/xml", "text/xml", 200);
    }

    @Test
    public void testGetBookByHeaderDefault() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/bookheaders2", "resources/expected_get_book123.txt", "application/xml;q=0.5,text/xml", "text/xml", 200);
    }

    @Test
    public void testGetBookElement() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/element", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBookAdapter() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/adapter", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123FromSub() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/interface/subresource", "resources/expected_get_book123.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/books/123", "resources/expected_get_book123json.txt", "application/xml;q=0.1,application/json", "application/json", 200);
    }

    @Test
    public void testGetBook123FromSubObject() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booksubresourceobject/123/chaptersobject/sub/1", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=iso-8859-1", 200);
    }

    @Test
    public void testGetChapter() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booksubresource/123/chapters/1", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=iso-8859-1", 200);
    }

    @Test
    public void testGetChapterEncodingDefault() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booksubresource/123/chapters/badencoding/1", "resources/expected_get_chapter1_utf.txt", "application/xml", "application/xml;charset=UTF-8", 200);
    }

    @Test
    public void testGetChapterChapter() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booksubresource/123/chapters/sub/1/recurse", "resources/expected_get_chapter1_utf.txt", "application/xml", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booksubresource/123/chapters/sub/1/recurse2", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=iso-8859-1", 200);
    }

    @Test
    public void testGetChapterWithParentIds() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booksubresource/123/chapters/sub/1/recurse2/ids", "resources/expected_get_chapter1.txt", "application/xml", "application/xml;charset=iso-8859-1", 200);
    }

    @Test
    public void testGetBook123ReturnString() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/booknames/123", "resources/expected_get_book123_returnstring.txt", "text/plain", 200);
    }

    @Test
    public void testAddBook() throws Exception {
        this.doAddBook("http://localhost:9080/bookstore/books");
    }

    @Test
    public void testAddBookXmlAdapter() throws Exception {
        this.doAddBook("http://localhost:9080/bookstore/booksinfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddBook(String address) throws Exception {
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/add_book.txt").toURI());
        PostMethod post = new PostMethod(address);
        post.setRequestHeader("Content-Type", "application/xml");
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_add_book.txt");
            JAXRSClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)post.getResponseBodyAsString());
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBook() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book.txt").toURI());
        PutMethod put = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            put.releaseConnection();
        }
        endpointAddress = "http://localhost:9080/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        InputStream in = connect.getInputStream();
        JAXRSClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_update_book.txt");
        JAXRSClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
        File input1 = new File(((Object)((Object)this)).getClass().getResource("resources/expected_get_book123.txt").toURI());
        PutMethod put1 = new PutMethod(endpointAddress);
        FileRequestEntity entity1 = new FileRequestEntity(input1, "text/xml; charset=ISO-8859-1");
        put1.setRequestEntity((RequestEntity)entity1);
        HttpClient httpclient1 = new HttpClient();
        try {
            int result = httpclient1.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            put1.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBookWithDom() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/bookswithdom";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book.txt").toURI());
        PutMethod put = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            String resp = put.getResponseBodyAsString();
            InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/update_book.txt");
            JAXRSClientServerBookTest.assertTrue((resp.indexOf(this.getStringFromInputStream(expected)) >= 0 ? 1 : 0) != 0);
        }
        finally {
            put.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBookWithJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/bookswithjson";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book_json.txt").toURI());
        PutMethod put = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "application/json; charset=ISO-8859-1");
        put.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            put.releaseConnection();
        }
        endpointAddress = "http://localhost:9080/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("Accept", "application/xml");
        InputStream in = connection.getInputStream();
        JAXRSClientServerBookTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_update_book.txt");
        JAXRSClientServerBookTest.assertEquals((Object)this.getStringFromInputStream(expected), (Object)this.getStringFromInputStream(in));
        File input1 = new File(((Object)((Object)this)).getClass().getResource("resources/expected_get_book123.txt").toURI());
        PutMethod put1 = new PutMethod(endpointAddress);
        FileRequestEntity entity1 = new FileRequestEntity(input1, "text/xml; charset=ISO-8859-1");
        put1.setRequestEntity((RequestEntity)entity1);
        HttpClient httpclient1 = new HttpClient();
        try {
            int result = httpclient1.executeMethod((HttpMethod)put);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            put1.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateBookFailed() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/books";
        File input = new File(((Object)((Object)this)).getClass().getResource("resources/update_book_not_exist.txt").toURI());
        PutMethod post = new PutMethod(endpointAddress);
        FileRequestEntity entity = new FileRequestEntity(input, "text/xml; charset=ISO-8859-1");
        post.setRequestEntity((RequestEntity)entity);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)304L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Test
    public void testGetCDs() throws Exception {
        WebClient wc = WebClient.create((String)"http://localhost:9080/bookstore/cds");
        CDs cds = (CDs)wc.get(CDs.class);
        Collection<CD> collection = cds.getCD();
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)collection.size());
        JAXRSClientServerBookTest.assertTrue((boolean)collection.contains(new CD("BICYCLE RACE", 124L)));
        JAXRSClientServerBookTest.assertTrue((boolean)collection.contains(new CD("BOHEMIAN RHAPSODY", 123L)));
    }

    @Test
    public void testGetCDJSON() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/cd/123", "resources/expected_get_cdjson.txt", "application/json", 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPlainLong() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/booksplain";
        PostMethod post = new PostMethod(endpointAddress);
        post.addRequestHeader("Content-Type", "text/plain");
        post.addRequestHeader("Accept", "text/plain");
        post.setRequestBody("12345");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            JAXRSClientServerBookTest.assertEquals((Object)post.getResponseBodyAsString(), (Object)"12345");
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteBook() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/books/123";
        DeleteMethod post = new DeleteMethod(endpointAddress);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteBookByQuery() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/books/id?value=123";
        DeleteMethod post = new DeleteMethod(endpointAddress);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)post);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCDsJSON() throws Exception {
        String endpointAddress = "http://localhost:9080/bookstore/cds";
        GetMethod get = new GetMethod(endpointAddress);
        get.addRequestHeader("Accept", "application/json");
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)200L, (long)result);
            InputStream expected123 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_cdsjson123.txt");
            InputStream expected124 = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_cdsjson124.txt");
            JAXRSClientServerBookTest.assertTrue((get.getResponseBodyAsString().indexOf(this.getStringFromInputStream(expected123)) >= 0 ? 1 : 0) != 0);
            JAXRSClientServerBookTest.assertTrue((get.getResponseBodyAsString().indexOf(this.getStringFromInputStream(expected124)) >= 0 ? 1 : 0) != 0);
        }
        finally {
            get.releaseConnection();
        }
    }

    @Test
    public void testGetCDXML() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/cd/123", "resources/expected_get_cd.txt", "application/xml", 200);
    }

    @Test
    public void testGetCDWithMultiContentTypesXML() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/cdwithmultitypes/123", "resources/expected_get_cd.txt", "application/json;q=0.8,application/xml,*/*", "application/xml", 200);
    }

    @Test
    public void testGetCDWithMultiContentTypesCustomXML() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/cdwithmultitypes/123", "resources/expected_get_cd.txt", "application/bar+xml", "application/bar+xml", 200);
    }

    @Test
    public void testGetCDWithMultiContentTypesJSON() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/cdwithmultitypes/123", "resources/expected_get_cdjson.txt", "application/json", 200);
        this.getAndCompareAsStrings("http://localhost:9080/bookstore/cdwithmultitypes/123", "resources/expected_get_cdjson.txt", "*/*,application/xml;q=0.9,application/json", "application/json", 200);
    }

    @Test
    public void testUriInfoMatchedResources() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/booksubresource/123/chapters/sub/1/matched-resources", "[class org.apache.cxf.systest.jaxrs.BookStore, class org.apache.cxf.systest.jaxrs.Book, class org.apache.cxf.systest.jaxrs.Chapter]", "text/plain", "text/plain", 200);
    }

    @Test
    public void testUriInfoMatchedResourcesWithObject() throws Exception {
        this.getAndCompare("http://localhost:9080/bookstore/booksubresource/123/chaptersobject/sub/1/matched-resources", "[class org.apache.cxf.systest.jaxrs.BookStore, class org.apache.cxf.systest.jaxrs.Book, class org.apache.cxf.systest.jaxrs.Chapter]", "text/plain", "text/plain", 200);
    }

    @Test
    public void testUriInfoMatchedUrisDecode() throws Exception {
        String expected = "[/bookstore/booksubresource/123/, /bookstore/booksubresource/123/chapters/sub/1/, /bookstore/booksubresource/123/chapters/sub/1/matched!uris]";
        this.getAndCompare("http://localhost:9080/bookstore/booksubresource/123/chapters/sub/1/matched%21uris?decode=true", expected, "text/plain", "text/plain", 200);
    }

    @Test
    public void testUriInfoMatchedUrisNoDecode() throws Exception {
        String expected = "[/bookstore/booksubresource/123/, /bookstore/booksubresource/123/chapters/sub/1/, /bookstore/booksubresource/123/chapters/sub/1/matched%21uris]";
        this.getAndCompare("http://localhost:9080/bookstore/booksubresource/123/chapters/sub/1/matched%21uris?decode=false", expected, "text/plain", "text/plain", 200);
    }

    private void getAndCompareAsStrings(String address, String resourcePath, String acceptType, int status) throws Exception {
        String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
        this.getAndCompare(address, expected, acceptType, acceptType, status);
    }

    private void getAndCompareAsStrings(String address, String resourcePath, String acceptType, String expectedContentType, int status) throws Exception {
        String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
        this.getAndCompare(address, expected, acceptType, expectedContentType, status);
    }

    private void getAndCompare(String address, String expectedValue, String acceptType, int expectedStatus) throws Exception {
        this.getAndCompare(address, expectedValue, acceptType, null, expectedStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompare(String address, String expectedValue, String acceptType, String expectedContentType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        get.setRequestHeader("Accept-Language", "da;q=0.8,en");
        get.setRequestHeader("Book", "1,2,3");
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)expectedStatus, (long)result);
            String content = this.getStringFromInputStream(get.getResponseBodyAsStream());
            JAXRSClientServerBookTest.assertEquals((String)"Expected value is wrong", (Object)expectedValue, (Object)content);
            if (expectedStatus == 200) {
                JAXRSClientServerBookTest.assertEquals((Object)"123", (Object)get.getResponseHeader("BookId").getValue());
                JAXRSClientServerBookTest.assertNotNull((Object)get.getResponseHeader("Date"));
            }
            if (expectedStatus == 405) {
                JAXRSClientServerBookTest.assertNotNull((Object)get.getResponseHeader("Allow"));
            }
            if (expectedContentType != null) {
                Header ct = get.getResponseHeader("Content-Type");
                JAXRSClientServerBookTest.assertEquals((String)"Wrong type of response", (Object)expectedContentType, (Object)ct.getValue());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompareStrings(String address, String[] expectedValue, String acceptType, int expectedStatus) throws Exception {
        JAXRSClientServerBookTest.assertEquals((long)2L, (long)expectedValue.length);
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerBookTest.assertEquals((long)expectedStatus, (long)result);
            String jsonContent = this.getStringFromInputStream(get.getResponseBodyAsStream());
            JAXRSClientServerBookTest.assertTrue((String)"Expected value is wrong", (expectedValue[0].equals(jsonContent) || expectedValue[1].equals(jsonContent) ? 1 : 0) != 0);
        }
        finally {
            get.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

