/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.BookServerResourceCreatedSpringProviders;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSClientServerResourceCreatedSpringProviderTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerResourceCreatedSpringProviderTest.launchServer(BookServerResourceCreatedSpringProviders.class));
    }

    @Test
    public void testMultipleRootsWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:9080/webapp/", "http://localhost:9080/webapp/", 2);
        String path1 = resourceEls.get(0).getAttribute("path");
        int bookStoreInd = path1.contains("/bookstore") ? 0 : 1;
        int petStoreInd = bookStoreInd == 0 ? 1 : 0;
        this.checkBookStoreInfo(resourceEls.get(bookStoreInd));
        this.checkPetStoreInfo(resourceEls.get(petStoreInd));
    }

    @Test
    public void testBookStoreWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:9080/webapp/", "http://localhost:9080/webapp/bookstore", 1);
        this.checkBookStoreInfo(resourceEls.get(0));
    }

    @Test
    public void testPetStoreWadl() throws Exception {
        List<Element> resourceEls = this.getWadlResourcesInfo("http://localhost:9080/webapp/", "http://localhost:9080/webapp/petstore", 1);
        this.checkPetStoreInfo(resourceEls.get(0));
    }

    private void checkBookStoreInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/bookstore", (Object)resource.getAttribute("path"));
    }

    private void checkPetStoreInfo(Element resource) {
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"/petstore/", (Object)resource.getAttribute("path"));
    }

    private List<Element> getWadlResourcesInfo(String baseURI, String requestURI, int size) throws Exception {
        WebClient client = WebClient.create((String)(requestURI + "?_wadl&_type=xml"));
        Document doc = DOMUtils.readXml((Reader)new InputStreamReader((InputStream)client.get(InputStream.class), "UTF-8"));
        Element root = doc.getDocumentElement();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"http://research.sun.com/wadl/2006/10", (Object)root.getNamespaceURI());
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)"application", (Object)root.getLocalName());
        List resourcesEls = DOMUtils.getChildrenWithName((Element)root, (String)"http://research.sun.com/wadl/2006/10", (String)"resources");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)1L, (long)resourcesEls.size());
        Element resourcesEl = (Element)resourcesEls.get(0);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((Object)baseURI, (Object)resourcesEl.getAttribute("base"));
        List resourceEls = DOMUtils.getChildrenWithName((Element)resourcesEl, (String)"http://research.sun.com/wadl/2006/10", (String)"resource");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)size, (long)resourceEls.size());
        return resourceEls;
    }

    @Test
    public void testGetBook123() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/books/123";
        URL url = new URL(endpointAddress);
        URLConnection connect = url.openConnection();
        connect.addRequestProperty("Accept", "application/json");
        connect.addRequestProperty("Content-Language", "badgerFishLanguage");
        InputStream in = connect.getInputStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book123badgerfish.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"BadgerFish output not correct", (Object)this.getStringFromInputStream(expected).trim(), (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetBookNotFound() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/books/12345";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "text/plain,application/xml");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)500L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        InputStream expected = ((Object)((Object)this)).getClass().getResourceAsStream("resources/expected_get_book_notfound_mapped.txt");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)this.getStringFromInputStream(expected).trim(), (Object)this.getStringFromInputStream(in).trim());
    }

    @Test
    public void testGetBookNotExistent() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/bookstore/nonexistent";
        URL url = new URL(endpointAddress);
        HttpURLConnection connect = (HttpURLConnection)url.openConnection();
        connect.addRequestProperty("Accept", "application/xml");
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)405L, (long)connect.getResponseCode());
        InputStream in = connect.getErrorStream();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertNotNull((Object)in);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Exception is not mapped correctly", (Object)"Nonexistent method", (Object)this.getStringFromInputStream(in).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus() throws Exception {
        String endpointAddress = "http://localhost:9080/webapp/petstore/pets";
        URL url = new URL(endpointAddress);
        HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
        httpUrlConnection.setUseCaches(false);
        httpUrlConnection.setDefaultUseCaches(false);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setDoInput(true);
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Accept", "text/xml");
        httpUrlConnection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        httpUrlConnection.setRequestProperty("Connection", "close");
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        File inputFile = new File(((Object)((Object)this)).getClass().getResource("resources/singleValPostBody.txt").toURI());
        byte[] tmp = new byte[4096];
        int i = 0;
        FileInputStream is = new FileInputStream(inputFile);
        try {
            while ((i = ((InputStream)is).read(tmp)) >= 0) {
                outputstream.write(tmp, 0, i);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        outputstream.flush();
        int responseCode = httpUrlConnection.getResponseCode();
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((long)200L, (long)responseCode);
        JAXRSClientServerResourceCreatedSpringProviderTest.assertEquals((String)"Wrong status returned", (Object)"open", (Object)this.getStringFromInputStream(httpUrlConnection.getInputStream()));
        httpUrlConnection.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostPetStatus2() throws Exception {
        Socket s = new Socket("localhost", 9080);
        IOUtils.copyAndCloseInput((InputStream)((Object)((Object)this)).getClass().getResource("resources/formRequest.txt").openStream(), (OutputStream)s.getOutputStream());
        s.getOutputStream().flush();
        try {
            JAXRSClientServerResourceCreatedSpringProviderTest.assertTrue((String)"Wrong status returned", (boolean)this.getStringFromInputStream(s.getInputStream()).contains("open"));
        }
        finally {
            s.close();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        return IOUtils.toString((InputStream)in);
    }
}

