/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.systest.jaxrs.BookContinuationServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class JAXRSContinuationsTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSContinuationsTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSContinuationsTest.launchServer(BookContinuationServer.class));
    }

    @Test
    public void testContinuation() throws Exception {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        CountDownLatch startSignal = new CountDownLatch(1);
        CountDownLatch doneSignal = new CountDownLatch(5);
        executor.execute(new BookWorker("http://localhost:9080/bookstore/books/1", "1", "CXF in Action1", startSignal, doneSignal));
        executor.execute(new BookWorker("http://localhost:9080/bookstore/books/2", "2", "CXF in Action2", startSignal, doneSignal));
        executor.execute(new BookWorker("http://localhost:9080/bookstore/books/3", "3", "CXF in Action3", startSignal, doneSignal));
        executor.execute(new BookWorker("http://localhost:9080/bookstore/books/4", "4", "CXF in Action4", startSignal, doneSignal));
        executor.execute(new BookWorker("http://localhost:9080/bookstore/books/5", "5", "CXF in Action5", startSignal, doneSignal));
        startSignal.countDown();
        doneSignal.await(60L, TimeUnit.SECONDS);
        executor.shutdownNow();
        JAXRSContinuationsTest.assertEquals((String)"Not all invocations have completed", (long)0L, (long)doneSignal.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBook(String address, String id, String expected) throws Exception {
        GetMethod get = new GetMethod(address);
        HttpClient httpclient = new HttpClient();
        try {
            int result = httpclient.executeMethod((HttpMethod)get);
            JAXRSContinuationsTest.assertEquals((long)200L, (long)result);
            JAXRSContinuationsTest.assertEquals((String)("Book description for id " + id + " is wrong"), (Object)expected, (Object)get.getResponseBodyAsString());
        }
        finally {
            get.releaseConnection();
        }
    }

    @Ignore
    private class BookWorker
    implements Runnable {
        private String address;
        private String id;
        private String expected;
        private CountDownLatch startSignal;
        private CountDownLatch doneSignal;

        public BookWorker(String address, String id, String expected, CountDownLatch startSignal, CountDownLatch doneSignal) {
            this.address = address;
            this.id = id;
            this.expected = expected;
            this.startSignal = startSignal;
            this.doneSignal = doneSignal;
        }

        public void run() {
            try {
                this.startSignal.await();
                JAXRSContinuationsTest.this.checkBook(this.address, this.id, this.expected);
                this.doneSignal.countDown();
            }
            catch (InterruptedException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Book thread failed for : " + this.id));
            }
        }
    }
}

