/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.Book2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/bookstore")
public class MultipartStore {
    @Context
    private MessageContext context;

    @POST
    @Path(value="/books/image")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    public byte[] addBookImage(byte[] image) throws Exception {
        return image;
    }

    @POST
    @Path(value="/books/formimage")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"multipart/form-data"})
    public MultipartBody addBookFormImage(MultipartBody image) throws Exception {
        return image;
    }

    @POST
    @Path(value="/books/jaxbjsonimage")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    public Map<String, Object> addBookJaxbJsonImage(@Multipart(value="root.message@cxf.apache.org") Book jaxb, @Multipart(value="1") Book json, @Multipart(value="2") byte[] image) throws Exception {
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        objects.put("application/octet-stream", new ByteArrayInputStream(image));
        return objects;
    }

    @POST
    @Path(value="/books/jaxbimagejson")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed"})
    public Map<String, Object> addBookJaxbJsonImage2(@Multipart(value="theroot") Book jaxb, @Multipart(value="thejson") Book json, @Multipart(value="theimage") byte[] image) throws Exception {
        LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
        objects.put("application/xml", jaxb);
        objects.put("application/json", json);
        objects.put("application/octet-stream", new ByteArrayInputStream(image));
        return objects;
    }

    @POST
    @Path(value="/books/stream")
    @Produces(value={"text/xml"})
    public Response addBookFromStream(StreamSource source) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        Book b = (Book)u.unmarshal((Source)source);
        b.setId(124L);
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/form")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    public Response addBookFromForm(MultivaluedMap<String, String> data) throws Exception {
        Book b = new Book();
        b.setId(Long.valueOf((String)data.getFirst((Object)"id")));
        b.setName((String)data.getFirst((Object)"name"));
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/formbody")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    public Response addBookFromFormBody(MultipartBody body) throws Exception {
        MultivaluedMap data = AttachmentUtils.populateFormMap((MessageContext)this.context);
        Book b = new Book();
        b.setId(Long.valueOf((String)data.getFirst((Object)"id")));
        b.setName((String)data.getFirst((Object)"name"));
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/formbody2")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    public Response addBookFromFormBody2() throws Exception {
        return this.addBookFromFormBody(AttachmentUtils.getMultipartBody((MessageContext)this.context));
    }

    @POST
    @Path(value="/books/formparam")
    @Produces(value={"text/xml"})
    public Response addBookFromFormParam(@FormParam(value="name") String title, @FormParam(value="id") Long id) throws Exception {
        Book b = new Book();
        b.setId(id);
        b.setName(title);
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/formparambean")
    @Produces(value={"text/xml"})
    public Response addBookFromFormParam(@FormParam(value="") Book b) throws Exception {
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/istream")
    @Produces(value={"text/xml"})
    public Response addBookFromInputStream(InputStream is) throws Exception {
        return this.readBookFromInputStream(is);
    }

    @POST
    @Path(value="/books/dsource")
    @Produces(value={"text/xml"})
    public Response addBookFromDataSource(DataSource ds) throws Exception {
        return this.readBookFromInputStream(ds.getInputStream());
    }

    @POST
    @Path(value="/books/jaxb2")
    @Consumes(value={"multipart/related;type=\"text/xml\""})
    @Produces(value={"text/xml"})
    public Response addBookParts(@Multipart(value="rootPart") Book b1, @Multipart(value="book2") Book b2) throws Exception {
        if (b1.equals(b2)) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        b1.setId(124L);
        return Response.ok((Object)b1).build();
    }

    @POST
    @Path(value="/books/jaxbonly")
    @Consumes(value={"multipart/mixed"})
    @Produces(value={"multipart/mixed;type=text/xml"})
    public List<Book> addBooks(List<Book> books) {
        ArrayList<Book> books2 = new ArrayList<Book>();
        books2.addAll(books);
        return books2;
    }

    @POST
    @Path(value="/books/jaxbjson")
    @Produces(value={"text/xml"})
    public Response addBookJaxbJson(@Multipart(value="rootPart", type="text/xml") Book2 b1, @Multipart(value="book2", type="application/json") Book b2) throws Exception {
        if (!"CXF in Action".equals(b1.getName()) || !"CXF in Action - 2".equals(b2.getName())) {
            throw new WebApplicationException();
        }
        b2.setId(124L);
        return Response.ok((Object)b2).build();
    }

    @POST
    @Path(value="/books/dsource2")
    @Produces(value={"text/xml"})
    public Response addBookFromDataSource2(@Multipart(value="rootPart") DataSource ds1, @Multipart(value="book2") DataSource ds2) throws Exception {
        Book b2;
        Response r1 = this.readBookFromInputStream(ds1.getInputStream());
        Response r2 = this.readBookFromInputStream(ds2.getInputStream());
        Book b1 = (Book)r1.getEntity();
        if (b1.equals(b2 = (Book)r2.getEntity())) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        return r1;
    }

    @POST
    @Path(value="/books/listattachments")
    @Produces(value={"text/xml"})
    public Response addBookFromListOfAttachments(List<Attachment> atts) throws Exception {
        Book b2;
        Response r1 = this.readBookFromInputStream(atts.get(0).getDataHandler().getInputStream());
        Response r2 = this.readBookFromInputStream(atts.get(2).getDataHandler().getInputStream());
        Book b1 = (Book)r1.getEntity();
        if (b1.equals(b2 = (Book)r2.getEntity())) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        return r1;
    }

    @POST
    @Path(value="/books/body")
    @Produces(value={"text/xml"})
    public Response addBookFromListOfAttachments(MultipartBody body) throws Exception {
        return this.addBookFromListOfAttachments(body.getAllAttachments());
    }

    @POST
    @Path(value="/books/lististreams")
    @Produces(value={"text/xml"})
    public Response addBookFromListOfStreams(List<InputStream> atts) throws Exception {
        Book b2;
        Response r1 = this.readBookFromInputStream(atts.get(0));
        Response r2 = this.readBookFromInputStream(atts.get(2));
        Book b1 = (Book)r1.getEntity();
        if (b1.equals(b2 = (Book)r2.getEntity())) {
            throw new WebApplicationException();
        }
        if (!b1.getName().equals(b2.getName())) {
            throw new WebApplicationException();
        }
        return r1;
    }

    @POST
    @Path(value="/books/dhandler")
    @Produces(value={"text/xml"})
    public Response addBookFromDataHandler(DataHandler dh) throws Exception {
        return this.readBookFromInputStream(dh.getInputStream());
    }

    @POST
    @Path(value="/books/attachment")
    @Produces(value={"text/xml"})
    public Response addBookFromAttachment(Attachment a) throws Exception {
        return this.readBookFromInputStream(a.getDataHandler().getInputStream());
    }

    @POST
    @Path(value="/books/mchandlers")
    @Produces(value={"text/xml"})
    public Response addBookFromMessageContext() throws Exception {
        Map handlers = AttachmentUtils.getAttachmentsMap((MessageContext)this.context);
        for (Map.Entry entry : handlers.entrySet()) {
            if (!((String)entry.getKey()).equals("book2")) continue;
            return this.readBookFromInputStream(((Attachment)entry.getValue()).getDataHandler().getInputStream());
        }
        throw new WebApplicationException(500);
    }

    @POST
    @Path(value="/books/attachments")
    @Produces(value={"text/xml"})
    public Response addBookFromAttachments() throws Exception {
        List handlers = AttachmentUtils.getChildAttachments((MessageContext)this.context);
        for (Attachment a : handlers) {
            if (!a.getContentId().equals("book2")) continue;
            return this.readBookFromInputStream(a.getDataHandler().getInputStream());
        }
        throw new WebApplicationException(500);
    }

    @POST
    @Path(value="/books/jaxb")
    @Produces(value={"text/xml"})
    public Response addBook(Book b) throws Exception {
        b.setId(124L);
        return Response.ok((Object)b).build();
    }

    @POST
    @Path(value="/books/mismatch1")
    @Consumes(value={"multipart/related;type=\"bar/foo\""})
    @Produces(value={"text/xml"})
    public Response addBookMismatched(Book b) {
        throw new WebApplicationException();
    }

    @POST
    @Path(value="/books/mismatch2")
    @Produces(value={"text/xml"})
    public Response addBookMismatched2(@Multipart(value="rootPart", type="f/b") Book b) {
        throw new WebApplicationException();
    }

    private Response readBookFromInputStream(InputStream is) throws Exception {
        JAXBContext c = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Unmarshaller u = c.createUnmarshaller();
        Book b = (Book)u.unmarshal(is);
        b.setId(124L);
        return Response.ok((Object)b).build();
    }
}

