/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs.security;

import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookStore;
import org.apache.cxf.systest.jaxrs.security.BookHttpsServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSHttpsBookTest
extends AbstractBusClientServerTestBase {
    private static final String CLIENT_CONFIG_FILE = "org/apache/cxf/systest/jaxrs/security/jaxrs-https.xml";
    private static final String CLIENT_CONFIG_FILE2 = "org/apache/cxf/systest/jaxrs/security/jaxrs-https-url.xml";

    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSHttpsBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSHttpsBookTest.launchServer(BookHttpsServer.class));
    }

    @Test
    public void testGetBook123Proxy() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"https://localhost:9095", BookStore.class, (String)CLIENT_CONFIG_FILE);
        JAXRSHttpsBookTest.assertEquals((Object)"https://localhost:9095", (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123ProxyWithURLConduitId() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"https://localhost:9095", BookStore.class, (String)CLIENT_CONFIG_FILE2);
        JAXRSHttpsBookTest.assertEquals((Object)"https://localhost:9095", (Object)WebClient.client((Object)bs).getBaseURI().toString());
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
    }

    @Test
    public void testGetBook123ProxyToWebClient() throws Exception {
        BookStore bs = (BookStore)JAXRSClientFactory.create((String)"https://localhost:9095", BookStore.class, (String)CLIENT_CONFIG_FILE);
        Book b = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b.getId(), (long)123L);
        WebClient wc = WebClient.fromClient((Client)WebClient.client((Object)bs));
        wc.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b2 = (Book)wc.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b2.getId());
    }

    @Test
    public void testGetBook123WebClientToProxy() throws Exception {
        WebClient wc = WebClient.create((String)"https://localhost:9095", (String)CLIENT_CONFIG_FILE);
        wc.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)wc.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
        wc.back(true);
        BookStore bs = (BookStore)JAXRSClientFactory.fromClient((Client)wc, BookStore.class);
        Book b2 = bs.getSecureBook("123");
        JAXRSHttpsBookTest.assertEquals((long)b2.getId(), (long)123L);
    }

    @Test
    public void testGetBook123WebClient() throws Exception {
        WebClient client = WebClient.create((String)"https://localhost:9095", (String)CLIENT_CONFIG_FILE);
        JAXRSHttpsBookTest.assertEquals((Object)"https://localhost:9095", (Object)client.getBaseURI().toString());
        client.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
    }

    @Test
    public void testGetBook123WebClientWithURLConduitId() throws Exception {
        WebClient client = WebClient.create((String)"https://localhost:9095", (String)CLIENT_CONFIG_FILE2);
        JAXRSHttpsBookTest.assertEquals((Object)"https://localhost:9095", (Object)client.getBaseURI().toString());
        client.path((Object)"/bookstore/securebooks/123").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
        Book b = (Book)client.get(Book.class);
        JAXRSHttpsBookTest.assertEquals((long)123L, (long)b.getId());
    }
}

