/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.cxf.systest.jaxrs.Book;

public final class AtomUtils {
    private AtomUtils() {
    }

    public static Entry createBookEntry(Book b) throws Exception {
        return AtomUtils.createBookEntry(b, null);
    }

    public static Entry createBookEntry(Book b, String baseUri) throws Exception {
        Factory factory = Abdera.getNewFactory();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Book.class});
        Entry e = factory.getAbdera().newEntry();
        if (baseUri != null) {
            e.setBaseUri(baseUri);
        }
        e.setTitle(b.getName());
        e.setId(Long.toString(b.getId()));
        StringWriter writer = new StringWriter();
        jc.createMarshaller().marshal((Object)b, (Writer)writer);
        e.setContentElement(factory.newContent());
        e.getContentElement().setContentType(Content.Type.XML);
        e.getContentElement().setValue(writer.toString());
        return e;
    }
}

