/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import org.apache.cxf.systest.jaxrs.Book;
import org.apache.cxf.systest.jaxrs.BookInterface;
import org.apache.cxf.systest.jaxrs.BookNotFoundDetails;
import org.apache.cxf.systest.jaxrs.BookNotFoundFault;
import org.apache.cxf.systest.jaxrs.BookStoreStorage;
import org.apache.cxf.systest.jaxrs.LifecycleInterface;

public class BookStoreWithInterface
extends BookStoreStorage
implements BookInterface,
LifecycleInterface {
    private boolean postConstructCalled;

    public BookStoreWithInterface() {
        Book book = new Book();
        book.setId(this.bookId);
        book.setName("CXF in Action");
        this.books.put(book.getId(), book);
    }

    public void postConstruct() {
        this.postConstructCalled = true;
    }

    public void preDestroy() {
        System.out.println("PreDestroy called");
    }

    public Book getThatBook(Long id, String s) throws BookNotFoundFault {
        if (!this.postConstructCalled) {
            throw new RuntimeException();
        }
        if (!id.toString().equals(s)) {
            throw new RuntimeException();
        }
        return this.doGetBook(id);
    }

    public Book getThatBook(Long id) throws BookNotFoundFault {
        if (!this.postConstructCalled) {
            throw new RuntimeException();
        }
        return this.doGetBook(id);
    }

    private Book doGetBook(Long id) throws BookNotFoundFault {
        System.out.println("----invoking getBook with id: " + id);
        Book book = (Book)this.books.get(id);
        if (book != null) {
            return book;
        }
        BookNotFoundDetails details = new BookNotFoundDetails();
        details.setId(id);
        throw new BookNotFoundFault(details);
    }

    public Book getThatBook() throws BookNotFoundFault {
        return (Book)this.books.get(123L);
    }
}

