/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.jaxrs;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.systest.jaxrs.BookNonSpringServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class JAXRSClientServerNonSpringBookTest
extends AbstractBusClientServerTestBase {
    @BeforeClass
    public static void startServers() throws Exception {
        JAXRSClientServerNonSpringBookTest.assertTrue((String)"server did not launch correctly", (boolean)JAXRSClientServerNonSpringBookTest.launchServer(BookNonSpringServer.class));
    }

    @Test
    public void testGetBook123Singleton() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/singleton/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123UserModel() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/usermodel/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetChapterUserModel() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/usermodel/bookstore/books/123/chapter", "resources/expected_get_chapter1_utf.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123UserModelInterface() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/usermodel2/bookstore2/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123ApplicationSingleton() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/application/bookstore/books/123", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    @Test
    public void testGetBook123ApplicationPerRequest() throws Exception {
        this.getAndCompareAsStrings("http://localhost:9080/application/bookstore2/bookheaders", "resources/expected_get_book123.txt", "application/xml", 200);
    }

    private void getAndCompareAsStrings(String address, String resourcePath, String acceptType, int status) throws Exception {
        String expected = this.getStringFromInputStream(((Object)((Object)this)).getClass().getResourceAsStream(resourcePath));
        this.getAndCompare(address, expected, acceptType, acceptType, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndCompare(String address, String expectedValue, String acceptType, String expectedContentType, int expectedStatus) throws Exception {
        GetMethod get = new GetMethod(address);
        get.setRequestHeader("Accept", acceptType);
        get.setRequestHeader("Accept-Language", "da;q=0.8,en");
        get.setRequestHeader("Book", "1,2,3");
        HttpClient httpClient = new HttpClient();
        try {
            int result = httpClient.executeMethod((HttpMethod)get);
            JAXRSClientServerNonSpringBookTest.assertEquals((long)expectedStatus, (long)result);
            String content = this.getStringFromInputStream(get.getResponseBodyAsStream());
            JAXRSClientServerNonSpringBookTest.assertEquals((String)"Expected value is wrong", (Object)expectedValue, (Object)content);
            if (expectedContentType != null) {
                Header ct = get.getResponseHeader("Content-Type");
                JAXRSClientServerNonSpringBookTest.assertEquals((String)"Wrong type of response", (Object)expectedContentType, (Object)ct.getValue());
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    private String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }
}

